from openpi_client import websocket_client_policy

import numpy as np


def make_dvrk_example() -> dict:
    """Creates a random input example for the Aloha policy."""
    return {
        "state": np.zeros((16,)),
        "left_image": np.random.randint(256, size=(3, 224, 224), dtype=np.uint8),
        "endo_psm1_image": np.random.randint(256, size=(3, 224, 224), dtype=np.uint8),
        "endo_psm2_image": np.random.randint(256, size=(3, 224, 224), dtype=np.uint8),
        "prompt": "do something",
    }

policy_client = websocket_client_policy.WebsocketClientPolicy(host="127.0.0.1", port=8000)
example = make_dvrk_example()
action_chunk = policy_client.infer(example)["actions"]
print(action_chunk)