import os

### Dataset parameters
DATA_DIR = os.getenv("PATH_TO_DATASET")

INSTRUMENT_CLOSED_THRESHOLD = 0

# NOTE: Choose the dataset name as the dataset dir folder name
DATASET_CONFIGS = {
    "suturing": {
        "dataset_dir": os.path.join(DATA_DIR),
        "num_episodes": 1000, # And for validation doing num_episodes//2
        "tissue_samples_to_exclude": [], # Should not be used for HL policy training - good for LL and ML policy training 
        "tissue_samples_wrist_cameras_to_exclude": [],
        "camera_names": ["endo_psm2", "left_img_dir", "right_img_dir", "endo_psm1"], 
        "camera_file_suffixes": ["_psm2.jpg", "_left.jpg", "_right.jpg", "_psm1.jpg"],
        "after_phase_offset": 0,
        "before_phase_offset": 0, 
        "val_tissues": ([ "tissue_10"],),
        "tissue_samples_old_grab_pull_separation": [],
        "correct_psm1_rotation_tissues": [],
        "incomplete_demos_flag": False
    },
}
