- `ANON_Final_NeurIPS_submission_repo`
    - ★ **REPRODUCING.md**
    - `Fig2 - Hopf MetaLearning`
        - ★ **Dockerkfile**
        - - `v3_refactor`: The full code needed to reproduce gradient alignment
            - ★ Run the self-contained notebook: **`Refactor_CosineSimilarityOverTraining.ipynb`**
            - • Folder also includes analysis files of pre-trained logs
    - `Fig3 - Compositional Generalization`
        - ★ **Environment/Dockerkfile**
        - ★ Hyperparameter tuning can be recreated by running **`hyperparameter tuning-Demo.ipynb`**
        - ★ To train all models in model.py across the task with ascending complexity run [caution: 24 hours execution time]: **`GenerateComplexitySweep_MatchedRun.ipynb`**
    - `Fig4 - RL Bandit`
        - - `PPO_train_nmRNN`
            - ★ **environments/Dockerfile**
            - • Folder provides access to full repo and some trained example networks.
            - ★ To train a new e-nmRNN agent please specify local paths and run [warning execution time 24+ hours]: **`TrainNotebook.ipynb`**
            - ★ To regenerate the dynamics pictures of figure 4 on a new network, please run: **`AnalysisOfTrained_nmRNN.ipynb`**
        - - `MLE_Fits`
            - ★ **environments/Dockerfile**
            - ★ To reproduce the MLE fits and correlation analysis on a previously generated agent sequence please run: **`Notebooks/Fit_nmRNN_Agent_Analysis.ipynb`**
    - `Fig5 - Multitasking`
        - ★ `Yang19MultitaskingAll`
            - ★ **environment/Dockerfile**
            - ★ To train a new network please run [execution time 48+ hours] **`Demo_SpatialNetwork-Copy3.ipynb`**
            - ★ To analyze a new network please run **`Analysis_spatialNetwork-Alltasks.ipynb`**
        - - `AdaptatibilityNeurogym` A repo not used in the paper to study the adaptability of the nmRNN. This repo is in development but welcomes comments, corrections, and contributions.



This [Code Ocean](https://codeocean.com) Compute Capsule will allow you to run and reproduce the results of [CompGeneralizaion](https://codeocean.ANON/capsule/ANON/tree) on your local machine<sup>1</sup>. Follow the instructions below, or consult [our knowledge base](https://docs.codeocean.com/user-guide/compute-capsule-basics/managing-capsules/exporting-capsules-to-your-local-machine) for more information. Don't hesitate to reach out to [Support](mailto:support@codeocean.com) if you have any questions.

<sup>1</sup> You may need access to additional hardware and/or software licenses.

# Prerequisites

- [Docker Community Edition (CE)](https://www.docker.com/community-edition)
- [nvidia-container-runtime](https://docs.docker.com/config/containers/resource_constraints/#gpu) for code that leverages the GPU

# Instructions

## Log in to the Docker registry

In your terminal, execute the following command, providing your password or API key when prompted for it:
```shell
docker login -u ANON.email registry.codeocean.ANON
```

## Run the Capsule to reproduce the results

In your terminal, navigate to the folder where you've extracted the Capsule and execute the following command, adjusting parameters as needed:
```shell
docker run --platform linux/amd64 --rm --gpus all \
  --workdir /code \
  --volume "$PWD/code":/code \
  --volume "$PWD/data":/data \
  --volume "$PWD/results":/results \
  registry.codeocean.ANON/capsule/ANON \
  
```
