
import pymc as pm
import numpy as np
import arviz as az
import matplotlib.pyplot as plt

# Given Data
N = 12  # Number of observations
n = np.array([47, 148, 119, 810, 211, 196, 148, 215, 207, 97, 256, 360])
r = np.array([0, 18, 8, 46, 8, 13, 9, 31, 14, 8, 29, 24])

with pm.Model() as m:
	μ = pm.Normal('μ', mu=0, sd=10)
	σ = pm.HalfNormal('σ', sd=10)
	hospital_effects = pm.Normal('hospital_effects', mu=μ, sd=σ, shape=N)
	likelihood = pm.Poisson('likelihood', mu=hospital_effects, observed=r)

	trace = pm.sample(1000, tune=1000, chains=4, return_inferencedata=True, idata_kwargs={"log_likelihood": True})

	# Posterior diagnostics
	summary = az.summary(trace)