# Anonymous NeurIPS Submission Code

This repository contains the code used in the NeurIPS 2025 submission. Follow the steps below to set up the environment and run the main experiments.

## Environment Setup


### Step 1: Create and Activate Conda Environment

```bash
conda create -n refinestat-env python=3.11 -y
conda activate refinestat-env
```

```bash
conda install pip
```

```bash
cd refinestat
```

```bash
pip install -e .
pip install -r requirements.txt
```

To execute only the semantically constrained generation part i.e. RefineStat without Guided Resampling
```bash
python baseline.py
```

To execute the full RefineStat pipeline with Guided Resampling, here the number post -s represents the random seed number
```bash
python main.py -s 1
```
For computing the results of the baseline model, head to the nips/Baseline/ directory, and follow the following commands:

To obtain the results of the baseline model along with the reliability and token count, run the following command:
```bash
python baseline.py
```
To obtain the results of the baseline model with their compilation rate, run the following command:
```bash
python exec.py
```

To check the programs generated by GPT4-o3, check the nips/o3/o3-results.ipynb file