
import pymc as pm
import numpy as np
import arviz as az
import matplotlib.pyplot as plt

# Data
y = np.array([28, 8, -3, 7, -1, 1, 18, 12])
sigma = np.array([15, 10, 16, 11, 9, 11, 10, 18])

with pm.Model() as m:
	μ = pm.Normal('μ', mu=0, sigma=10, shape=8)
	sigma_μ = pm.HalfNormal('sigma_μ', sigma=1)

	y_obs = pm.Normal('y_obs', mu=μ, sigma=sigma, observed=y)

	trace = pm.sample(1000, tune=1000, chains=4, return_inferencedata=True, idata_kwargs={"log_likelihood": True})

	# Posterior diagnostics
	summary = az.summary(trace)