## Code Repository for Paper: Explaining Confident Black-Box Predictions

To run the results from the paper, run the file `run_results.py` with appropriate command-line arguments. See the file itself for details. 

To mine for rule lists or checklist rules on a dataset, see the following code snippets (duplicated from `run_results.py`)

```
dataset: Dataset
rulelist_params: RuleListMinerParams
target_support: float

miner = RuleListMiner(dataset, rulelist_params, False)
rule = miner.run(target_support=target_support)
```

You must implement your dataset as a subclass of `Dataset`, specify the rule list params and the target support level. 

For checklist rules: 

```
dataset: Dataset
checklist_params: ChecklistMinerParams
target_support: float

miner = ChecklistMiner(dataset, checklist_params, False)
rule = miner.run(target_support=target_support)
```
