"""
Demo script to test the ABBR experiment with a small number of seeds.
"""

import os

# Change to parent directory so data paths work correctly
script_dir = os.path.dirname(os.path.abspath(__file__))
parent_dir = os.path.dirname(script_dir)
os.chdir(parent_dir)

from abbr_experiment_config import ExperimentConfig, AVAILABLE_DATASETS
from abbr_multi_seed_experiment import run_multi_seed_experiment, print_summary_results

# Configure experiment with small number of seeds for testing
config = ExperimentConfig(
    dataset_class=AVAILABLE_DATASETS['diabetes'],
    confidence_threshold=0.9,
    min_rule_support=0.1,
    max_conditions_per_rule=3,
    num_seeds=10,  # Small number for quick testing
    num_rules_to_generate=1000,  # Fewer rules for faster execution
    max_valid_rules=500,
    save_detailed_results=False,  # Don't save for demo
    save_summary_results=False
)

print("Running ABBR experiment demo...")
print("This will test 5 random seeds to show how the experiment works.")

results_df, summary_stats = run_multi_seed_experiment(config)
print_summary_results(summary_stats)
print("\nDemo completed successfully!")
print("You can now run the full experiment with 100 seeds using:")
print("python run_abbr_experiment.py --dataset fico --seeds 100")