#include <bits/stdc++.h>
using namespace std;

const int maxn=200+5;
const int maxr=10+3;
int n,m;
int sum[maxn],num[maxn][maxn];
int pd[maxn][maxn];
int pos[maxn][maxn][maxn],ord[maxn][maxn][maxn];
double p;
int init() //data input
{
	memset(num,0,sizeof(num));
	memset(pd,0,sizeof(pd));
	scanf("%d%d%lf\n",&n,&m,&p);
	for (int i=1;i<=n;i++)
	{
		scanf("%d ",&sum[i]);
		char ch=getchar();
		int now=0;
		int obs=0;
		while (ch!='\n')
		{
			now++;
			num[i][now]=0;
			while (ch!=')')
			{
				ch=getchar();
				int s=0;
				for (s=ch-'0',ch=getchar();isdigit(ch);s=s*10+ch-'0',ch=getchar());
				obs++;
				num[i][now]++;
				pd[i][s]=now;
				pos[i][now][num[i][now]]=s;
				ord[i][now][num[i][now]]=obs;
			}
			ch=getchar();
		}
	}
	printf("%d %d %.2lf\n",n,m,p);
	for (int i=1;i<=n;i++)
	{
		printf("%d ",sum[i]);
		for (int j=1;j<=sum[i];j++)
		{
			printf("(");
			for (int k=1;k<num[i][j];k++)
			 printf("%d ",pos[i][j][k]);
			printf("%d)",pos[i][j][num[i][j]]);
		}
		printf("\n");
	}
	return 0;
}

int rec[maxn];
double f[maxn][maxn][maxr][maxr];
double dp(int ag) //calculate the fair probability for agent ag
{
	for (int i=1;i<=sum[ag]+1;i++)
	 for (int j=0;j<=num[ag][i];j++)
	  for (int k=0;k<=rec[i];k++)
	  	for (int l=0;l<=m/n+1;l++)
	  		f[i][j][k][l]=0;
	f[1][0][rec[1]][1]=1;
	for (int i=1;i<=sum[ag];i++)
	{
		for (int j=0;j<num[ag][i];j++)
		 for (int k=0;k<=rec[i] && k<=num[ag][i]-j;k++)
		 {
		 	if (k>0) f[i][j+1][k-1][0]+=f[i][j][k][0]*k/(num[ag][i]-j);
		 	if (k<num[ag][i]-j) f[i][j+1][k][0]+=f[i][j][k][0]*(num[ag][i]-j-k)/(num[ag][i]-j);
		 	for (int l=1;l<=m/n+1;l++)
		 	{
		 		int id=(ord[ag][i][j+1]%n==0);
		 		if (k>0) f[i][j+1][k-1][l+id-1]+=f[i][j][k][l]*k/(num[ag][i]-j);
		 		if (k<num[ag][i]-j) f[i][j+1][k][l+id]+=f[i][j][k][l]*(num[ag][i]-j-k)/(num[ag][i]-j); 
			 }
		 } 
		for (int l=0;l<=m/n+1;l++)
			f[i+1][0][rec[i+1]][l]=f[i][num[ag][i]][0][l];
	}
	return f[sum[ag]+1][0][0][0];
}

int nrec[maxn][maxn];
int que[maxn],sque;
int nownum[maxn];
double randomallocation() //test one random allocation for baseline
{
	sque=n;
	for (int i=1;i<=n;i++) que[i]=i;
	memset(nrec,0,sizeof(nrec));
	memset(nownum,0,sizeof(nownum));
	for (int i=1;i<=m;i++)
	 {
	 	int sq=rand()%sque+1;
	 	nrec[que[sq]][pd[que[sq]][i]]++;
	 	nownum[que[sq]]++;
	 	if (nownum[que[sq]]==m/n+1)
	 	{
	 		que[sq]=que[sque];
	 		sque--;
		 }
	 }
	double ans=1;
	for (int i=1;i<=n;i++)
	{
		memset(rec,0,sizeof(rec));
		for (int j=1;j<=sum[i];j++) rec[j]=nrec[i][j];
		ans*=dp(i);
	}
	return ans;
}
double baseline()
{
	double ans=0;
	for (int i=1;i<=m*4;i++) ans=max(ans,randomallocation()); //choose a random allocation
	return ans;
}

double tempans[maxn];
vector <int> owned[maxn];
double samplestart() // find the locally maximal allocation
{
	sque=n;
	for (int i=1;i<=n;i++) que[i]=i;
	memset(nrec,0,sizeof(nrec));
	memset(nownum,0,sizeof(nownum));
	for (int i=1;i<=n;i++) owned[i].clear();
	for (int i=1;i<=m;i++)
	 {
	 	int sq=rand()%sque+1;
	 	nrec[que[sq]][pd[que[sq]][i]]++;
	 	owned[que[sq]].push_back(i);
	 	nownum[que[sq]]++;
	 	if (nownum[que[sq]]==m/n+1)
	 	{
	 		que[sq]=que[sque];
	 		sque--;
		 }
	 }
	double ans=1;
	for (int i=1;i<=n;i++)
	{
		memset(rec,0,sizeof(rec));
		for (int j=1;j<=sum[i];j++) rec[j]=nrec[i][j];
		tempans[i]=dp(i);
	}
	bool boo=true;
	while (boo)
	{
		boo=false;
		for (int i=1;i<=n && !boo;i++)
		 for (int j=1;j<=n && !boo;j++)
		  if (i!=j && nownum[j]<m/n+1 && nownum[i]>0)
		   for (int k=0;k<nownum[i];k++)
		    {
		    	int item=owned[i][k];
		    	double pr=tempans[i]*tempans[j];
		    	double ns1=0,ns2=0;
		    	memset(rec,0,sizeof(rec));
				for (int l=1;l<=sum[i];l++) rec[l]=nrec[i][l];
				rec[pd[i][item]]--;
				ns1=dp(i);
				memset(rec,0,sizeof(rec));
				for (int l=1;l<=sum[j];l++) rec[l]=nrec[j][l];
				rec[pd[j][item]]++;
				ns2=dp(j);
				if (ns1*ns2>pr+(1e-6))
				{
					nrec[i][pd[i][item]]--;
					nrec[j][pd[j][item]]++;
					nownum[i]--;
					nownum[j]++;
					tempans[i]=ns1;
					tempans[j]=ns2;
					owned[i].erase(owned[i].begin()+k);
					owned[j].push_back(item);
					boo=true;
					break;
				}
			}
	}
	for (int i=1;i<=n;i++) ans*=tempans[i];
	return ans;
}
double localsearch()
{
	double ans=0;
	for (int i=1;i<=n;i++) ans=max(ans,samplestart()); //choose a random start point
	return ans;
}

int temprec[maxn][maxn],tempnum[maxn];
double nowvalue[maxn];
bool existing[maxn];
double ansavg[maxn][maxn];
double foundavg(int agent,int item)
{
	int now=pd[agent][item];
	int lef=0,rig=0;
	for (int i=1;i<now;i++) lef+=num[agent][i];
	rig=lef+num[agent][now];
	lef++;
	int ttm=0;
	double ans=0;
	for (int ob=0;ob<=m;ob+=n)
	{
		ttm++;
		int nowl=max(1,ob),nowr=min(m,ob+n-1);
		int rl=max(nowl,lef),rr=min(nowr,rig);
		int tot=max(0,rr-rl+1);
		ans+=tot*1.0/(rig-lef+1)/ttm;
	}
	return ans;
}
struct Edge
{
	int x,y,z,next;
	double w;
	Edge(int x=0,int y=0,int z=0,int next=0,double w=0.0):x(x),y(y),z(z),next(next),w(w) {}
}edge[maxn*maxn*2];
int sumedge,first[maxn*2],S,T;
int insedge(int x,int y,int z,double w)
{
	edge[++sumedge]=Edge(x,y,z,first[x],w);
	return first[x]=sumedge;
}
queue <int> spfaque;
double dist[maxn*2];
bool visit[maxn*2];
int comedge[maxn*2];
bool spfa()
{
	while (!spfaque.empty()) spfaque.pop();
	for (int i=S;i<=T;i++) dist[i]=-200;
	dist[S]=0;
	memset(visit,false,sizeof(visit));
	visit[S]=true;
	spfaque.push(S);
	while (!spfaque.empty())
	{
		int now=spfaque.front();
		spfaque.pop();
		visit[now]=false;
		for (int u=first[now];u>=0;u=edge[u].next)
		 if (edge[u].z>0 && dist[edge[u].y]<dist[now]+edge[u].w-(1e-6))
		 {
		 	dist[edge[u].y]=dist[now]+edge[u].w;
		 	comedge[edge[u].y]=u;
		 	if (visit[edge[u].y]) continue;
		 	visit[edge[u].y]=true;
		 	spfaque.push(edge[u].y);
		 }
	}
	if (dist[T]<1e-6) return false;
	int minn=200;
	for (int now=T;now!=S;now=edge[comedge[now]].x)
	{
		minn=min(minn,edge[comedge[now]].z);
	}
	for (int now=T;now!=S;now=edge[comedge[now]].x)
	{
		edge[comedge[now]].z-=minn;
		edge[comedge[now]^1].z+=minn;
	 } 
	return true;
}
double work3(double lb,double limit) //run the matching algorithm, lb is the lower bound L, limit is the upper bound U
{
	for (int i=1;i<=n;i++) nowvalue[i]=0;
	memset(existing,true,sizeof(existing));
	for (int i=1;i<=n;i++)
	 for (int j=1;j<=m;j++)
	  ansavg[i][j]=foundavg(i,j);
	memset(temprec,0,sizeof(temprec));
	memset(tempnum,0,sizeof(tempnum));
	for (int round=1;round<=m/n+1;round++)
	{
		sumedge=-1;
		memset(first,-1,sizeof(first));
		S=0;T=n+m+1;
		for (int i=1;i<=n;i++)  
		 if (nowvalue[i]<limit-(1e-6))
		 {
		 	insedge(S,i,1,0);
		 	insedge(i,S,0,0);
		 	for (int j=1;j<=m;j++)
		 	 if (existing[j])
		 	 {
		 	 	double tempavg=ansavg[i][j];
		 	 	if (tempavg<lb+(1e-6)) continue;
		 	 	insedge(i,n+j,1,tempavg*(1-nowvalue[i]));
		 	 	insedge(n+j,i,0,-tempavg*(1-nowvalue[i]));
		 	 //	insedge(i,n+j,1,tempavg);
		 	 //	insedge(n+j,i,0,-tempavg);
			  }
		 }
		for (int j=1;j<=m;j++)
		 if (existing[j])
		  {
		  	insedge(n+j,T,1,0);
		  	insedge(T,n+j,0,0);
		  }
		while (spfa());
		for (int i=1;i<=n;i++)
		 for (int u=first[i];u>=0;u=edge[u].next)
		  if (edge[u].y>n && edge[u].z==0)
		  {
		  	tempnum[i]++;
		  	temprec[i][pd[i][edge[u].y-n]]++;
		  	existing[edge[u].y-n]=false;
		  	nowvalue[i]+=edge[u].w;
		  }
	}
	int og=1;
	for (int i=1;i<=m;i++)
	 if (existing[i])
	 {
	 	while (og<=n && tempnum[og]==m/n+1) og++;
		tempnum[og]++;
		temprec[og][pd[og][i]]++;
	 }
	double ans=1;
	for (int i=1;i<=n;i++)
	{
		memset(rec,0,sizeof(rec));
		for (int j=1;j<=sum[i];j++) rec[j]=temprec[i][j];
		ans*=dp(i);
	}
	return ans;
}
double matching()
{
	double ans=0;
	for (int U=0;U<=10;U++) //choose the U from 1 down to 0.7
	 for (int L=0;L<=4;L++) //chose the L from 1/(m/n+1) to 1/(m/n+1)+0.1
		ans=max(ans,work3(1.0/(m/n+1)+0.1*L/4,1-0.3*U/10));
	return ans;
}
double work4(double limit) //greedy algorithm
{
	for (int i=1;i<=n;i++) nowvalue[i]=0;
	for (int i=1;i<=n;i++)
	 for (int j=1;j<=m;j++)
	  ansavg[i][j]=foundavg(i,j);
	memset(temprec,0,sizeof(temprec));
	memset(tempnum,0,sizeof(tempnum));
	for (int i=1;i<=m;i++)
	{
		int s=0;
		double maxadd=0;
		for (int j=1;j<=n;j++)
		 if (tempnum[j]<m/n+1)
		 {
		 if (s==0 || min(ansavg[j][i]*(1-nowvalue[j]),limit-nowvalue[j])>min(ansavg[s][i]*(1-nowvalue[s]),limit-nowvalue[s]))
		 	s=j;
		 }
		tempnum[s]++;
		temprec[s][pd[s][i]]++;
		nowvalue[s]+=ansavg[s][i]*(1-nowvalue[s]);
	}
	double ans=1;
	for (int i=1;i<=n;i++)
	{
		memset(rec,0,sizeof(rec));
		for (int j=1;j<=sum[i];j++) rec[j]=temprec[i][j];
		ans*=dp(i);
	}
	return ans;
}
double greedy()
{
	double ans=0;
	for (int U=0;U<=10;U++)  //choose the U from 1 down to 0.7
		ans=max(ans,work4(1-0.3*U/10));
	return ans;
}
double avg1,avg2,avg3,avg4;
double avgtim1,avgtim2,avgtim3,avgtim4;
int onetime(int totnum)
{
//	test baseline
	int tim1=clock();
	double ans1=baseline(); 
	tim1=clock()-tim1;

//	test localsearch
	int tim2=clock();
	double ans2=localsearch();
	tim2=clock()-tim2;

//	test matching
	int tim3=clock();
	double ans3=matching();
	tim3=clock()-tim3;

//	test greedy
	int tim4=clock();
	double ans4=greedy();
	tim4=clock()-tim4;
	
//	print the results
	printf("1:%.4lf 2:%.4lf 3:%.4lf 4:%.4lf\n",ans1,ans2,ans3,ans4);
	printf("time: 1:%d 2:%d 3:%d 4:%d\n",tim1,tim2,tim3,tim4);

//	print the temporary average results
	avg1+=ans1;
	avg2+=ans2;
	avg3+=ans3;
	avg4+=ans4;
	avgtim1+=tim1;
	avgtim2+=tim2;
	avgtim3+=tim3;
	avgtim4+=tim4;
	printf("Average: 1:%.4lf 2:%.4lf 3:%.4lf 4:%.4lf\n",avg1/totnum,avg2/totnum,avg3/totnum,avg4/totnum);
	printf("Average time: 1:%.2lf 2:%.2lf 3:%.2lf 4:%.2lf\n",avgtim1/totnum,avgtim2/totnum,avgtim3/totnum,avgtim4/totnum);
	return 0;
}
int main()
{
	srand(247111);	//choose an arbitrary random seed for easily re-running the program
	string st1="dataset";
	string st3=".in";
	string st4="rawresult";
	string st5=".out";
	for (int i=0;i<=25;i++) // the number of data files
	{
		fprintf(stderr,"Round: %d\n",i);
		string temp=st1+to_string(i)+st3,temp2=st4+to_string(i)+st5;
		freopen(temp.c_str(),"r",stdin);
		freopen(temp2.c_str(),"w",stdout);
		int num;
		while (scanf("%d:\n",&num)!=EOF)
		{
			fprintf(stderr,"%d\n",num);
			printf("%d:\n",num);
		//	fprintf(stderr,"%d:\n",num);
			init(); //take input for each data
			onetime(num); //test for each data
		}
	}
	return 0;
}
