#!/bin/bash
#SBATCH --job-name=brainlm                         # Job name
#SBATCH --output log_brainlm_%J.log                # Output log file
#SBATCH --mail-type=ALL                            # Mail events (NONE, BEGIN, END, FAIL, ALL)
#SBATCH --mail-user=<USER>@gmail.com               # Email address to send status updates to
#SBATCH --partition pi_dijk                        # Train on private partition
#SBATCH --requeue
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1                        # Run on a single CPU
#SBATCH --gres=gpu:rtx3090:1
#SBATCH --cpus-per-task=3
#SBATCH --mem=32gb                                 # Job memory request
#SBATCH --time=2-00:00:00                          # Time limit hrs:min:sec
date;hostname;pwd

python train.py \
    --output_dir training-runs/learned_pos2_tr2_weighted_40_80_test \
    --train_dataset_path /root/autodl-tmp/BrainLM-main/DataSet/movie_story_r_1000 \
    --val_dataset_path /root/autodl-tmp/BrainLM-main/DataSet/movie_story_r_1000_test \
    --num_timepoints_per_voxel 150 \
    --timepoint_patching_size 150 \
    --hidden_size 1024 \
    --num_hidden_layers 8 \
    --num_attention_heads 8 \
    --intermediate_size 1024 \
    --decoder_hidden_size 1024 \
    --decoder_num_hidden_layers 8 \
    --decoder_num_attention_heads 8 \
    --decoder_intermediate_size 1024 \
    --attention_probs_dropout_prob 0.1 \
    --per_device_train_batch_size 128 \
    --per_device_eval_batch_size 128 \
    --gradient_accumulation_steps 1 \
    --num_train_epochs 15000 \
    --save_total_limit 50000 \
    --dataloader_num_workers 12 \
    --save_steps 400 \
    --dataloader_pin_memory True