# AZ-whiteness test

## Structure of the repository 

The structure of the repository is the following:

- `graph_sign_test.py` implements the AZ-test and some utilities to analyze the prediction residuals.
- `triangular_tricom_graph.py` implements a family of graphs, and exposes plotting utilities.
- `synthetic_residuals.py` implements several targeted synthetic tests on correlated graph signals.
- `graph_polynomial_var.py` implements the GPVAR model and provides a dataset class usable in [TorchSpatiotemporal](https://github.com/TorchSpatiotemporal/tsl) and torch nn model.
- `tsl_experiments.py` extends the [traffic forecasting example](https://github.com/TorchSpatiotemporal/tsl/blob/main/examples/prediction/run_traffic.py) in TorchSpatiotemporal adding GPVAR model and data.


## Experiments and figures of the paper

The experiments of the paper are run with the following commands.

- Figure 3 is generated by calling `main("power-unimodal", disable_warning=True)` and `main("power-mixture", disable_warning=True)` in `synthetic_residual.py`.
- Figure 4 and Figure 6 (supplementary material) are generated from script `tsl_experiments.py` while running an experiment with `--dataset-name gpvar`.  
- Table 2 and Table 3 (supplementary material) are obtained from bash script `red_button.sh` that calls `tsl_experiments.py`. 
- Figure 5 (supplementary material) is generated by calling `main("viz")` in `synthetic_residual.py`.
- Figure 7 (supplementary material) is generated by calling `main("sparse-full")` in `synthetic_residual.py`.

Datasets are stored in folder `data`, 
figures generated by script `synthetic_residuals.py` are stored in folder `results`,
and results of `tsl_experiments.py` are stored in folder `log`.

Configuration files with model and training hyperparameters are in located in folder `config/traffic`.

