#!/bin/bash

#SBATCH -o run_logs/R-outFile_%j.txt

export TF_CPP_MIN_LOG_LEVEL=2

if [ $1 == "slurm" ];
then
    echo sbatch bash_scripts/execute_bash_file.sh $@
    echo ""
    echo "Number of CPU on this node: $SLURM_CPUS_ON_NODE"
    module load python/Anaconda3-2019
    source activate tf

    hostname
    echo ""
elif [ $1 == "local" ];
then 
    echo "Running locally"
    echo ""
else
    echo "Error: first argument must be either 'slurm' or 'local'"
    exit 1
fi

shift 1

bash $@