import os
import random
from PIL import Image, ImageDraw, ImageFont

def is_dark_image(image, threshold=30):
    grayscale_image = image.convert("L")
    histogram = grayscale_image.histogram()
    if sum(histogram[:threshold]) > 0.95 * sum(histogram):
        return True
    return False

def add_title(image, title, style, content, index, font_path='/usr/share/fonts/truetype/dejavu/DejaVuSans-Bold.ttf'):
    font = ImageFont.truetype(font_path, 20)
    draw = ImageDraw.Draw(image)
    if title == "target style":
        text = f"{index}: {style}"
    elif title == "target content":
        text = content
    else:
        text = title
    draw.text((10, 10), text, font=font, fill=(255, 255, 255))
    return image

def generate_method_order(seed):
    random.seed(seed)

    N = 50
    base_dir = f"./human_eval/figure_rank_three_{seed}"
    os.makedirs(base_dir, exist_ok=True)

    text_dir = f"{base_dir}/method_order"
    os.makedirs(text_dir, exist_ok=True)


    flip_results_file = f"{text_dir}/method_order_{seed}.txt"
    with open(flip_results_file, 'w') as f:
        f.write('')

    with open('prompt.txt', 'r') as f:
        folder_names = [name.strip() for name in f.read().splitlines()]

    with open('content.txt', 'r') as f:
        content_names = [name.strip() for name in f.read().splitlines()]

    with open('style.txt', 'r') as f:
        style_names = [name.strip() for name in f.read().splitlines()]

    for i in range(1, N + 1):
        while True:
            folder_index = random.randint(0, len(folder_names) - 1)
            folder = folder_names[folder_index]
            content_name = content_names[folder_index]
            style_name = style_names[folder_index]
            index = random.randint(0, 9)

            # ... (rest of your code here)
            # Define the image file names
            image1 = Image.open(f"fig/{folder}/p1_{index}.png")
            image2 = Image.open(f"fig/{folder}/p0_{index}.png")
            image3 = Image.open(f"fig/{folder}/p_compose_{index}.png")
            image4 = Image.open(f"fig/{folder}/proj_0.5_{index}.png")
            image5 = Image.open(f"fig/{folder}/p_direct_{index}.png")  # p_direct method image

            # Check if any image is completely dark
            if (not is_dark_image(image1)) and (not is_dark_image(image2)) and \
            (not is_dark_image(image3)) and (not is_dark_image(image4)) and \
            (not is_dark_image(image5)):  # also checking image5 now

                # Switch the order of image3, image4, image5 based on random sample
                method_images = {'p_compose': image3, 'proj_0.5': image4, 'p_direct': image5}
                method_order = random.sample(list(method_images.keys()), k=3)
                images_ordered = [method_images[method] for method in method_order]

                with open(flip_results_file, 'a') as f:
                    f.write(f"{i}:{folder}, {index}, {method_order[0]}, {method_order[1]}, {method_order[2]}\n")

                combined = Image.new('RGB', (image1.width * 5, image1.height + 50))  # Adjust the width for the new method
                combined.paste(add_title(image1, "target style", style_name, content_name, i), (0, 0))
                combined.paste(add_title(image2, "target content", style_name, content_name, i), (image1.width, 0))
                combined.paste(add_title(images_ordered[0], "method 0", style_name, content_name, i), (image1.width * 2, 0))
                combined.paste(add_title(images_ordered[1], "method 1", style_name, content_name, i), (image1.width * 3, 0))
                combined.paste(add_title(images_ordered[2], "method 2", style_name, content_name, i), (image1.width * 4, 0))

                temp_png_file = f"{base_dir}/temp_{i}.png"
                combined.save(temp_png_file)
                break

if __name__ == "__main__":
    # This block will allow you to run the script with a seed argument.
    # For example: python3 script_name.py 0
    import sys

    if len(sys.argv) != 2:
        print("Usage: python3 script_name.py <seed>")
        sys.exit(1)

    seed = int(sys.argv[1])
    generate_method_order(seed)

