deepspeed_config = {
    "optimizer": {
      "type": "AdamW",
      "params": {
        "lr": 3e-4,
        "weight_decay": 0,
        "betas": [0.9, 0.9]
      }
    },
    
    "scheduler": {
        "type": "WarmupLR",
        "params": {
            "warmup_min_lr": 3e-5,
            "warmup_max_lr": 3e-4,
            "warmup_num_steps": 5000
        }
    },
    
    "fp16": {
        "enabled": False,
        "min_loss_scale": 1
    },
    
    "zero_optimization": {
        "stage": 2,
        "cpu_offload": False,
        "contiguous_gradients": False
    },
    
    "train_batch_size": 32,
}


dynamic_deepspeed_config = {
    "optimizer": {
      "type": "AdamW",
      "params": {
        "lr": 3e-5,
        "weight_decay": 0,
        "betas": [0.9, 0.9]
      }
    },
    
    "scheduler": {
        "type": "WarmupLR",
        "params": {
            "warmup_min_lr": 3e-6,
            "warmup_max_lr": 3e-5,
            "warmup_num_steps": 5000
        }
    },
    
    "fp16": {
        "enabled": False,
        "min_loss_scale": 1
    },
    
    "zero_optimization": {
        "stage": 2,
        "cpu_offload": False,
        "contiguous_gradients": False
    },
    
    "train_batch_size": 64,
}


eval_deepspeed_config = {
    "train_micro_batch_size_per_gpu": 2,
    
    "fp16": {
        "enabled": False,
        "min_loss_scale": 1
    },
}