### Prerequisites
- Python >= 3.5
- Pytorch >= 1.3 and torchvision 
- You can use the `requirements.txt` file we provide to setup the environment via Anaconda.
```
conda create --name py36 python=3.6
conda install pytorch torchvision -c pytorch
pip3 install -r requirements.txt
```
### Datasets
Download 5 datasets seperately with the following commands.
- Set `DATASET_NAME` to: `cars`, `cub`, `miniImagenet`, `places`, or `plantae`.
```
cd filelists
python3 process.py DATASET_NAME
cd ..
```


### Feature encoder pre-training

- train your own pre-trained feature encoder (specify `PRETRAIN` to `baseline`) or use.
```
python3 train_baselineSSL.py --method PRETRAIN --dataset miniImagenet --name PRETRAIN --train_aug
```

### Training SSL_baseline with seen domains
Baseline training for prim-dual network.
- `METHOD` : metric-based framework `gnnnet`.
- `TESTSET`: unseen domain `cars`, `cub`, `places`, or `plantae`.
```
python3 train_baselineSSL.py --method METHOD --dataset miniImagenet or cub  --testset TESTSET --name multi_TESTSET_ori_METHOD --warmup PRETRAIN --train_aug
```

### Training final SSL_model 
Training final self-supervised prime-dual network.
```
python3 train_SSL.py --method METHOD --dataset miniImagenet or cub --testset TESTSET --name multi_TESTSET_lft_METHOD --warmup PRETRAIN --train_aug
```

### Evaluation
Test the metric-based framework `METHOD` on the unseen domain `TESTSET`.
- Specify the saved model you want to evaluate with `--name` (e.g., `--name multi_TESTSET_lft_METHOD` from the above example).

```
python3 test.py --method METHOD --name NAME --dataset TESTSET
```

note:
- Train or test SSL should import `SSL_1shot or SSL_5shot` file.
- Test SSO should import `SSL_1shot or SSL_5shot` file.
- 
