# Auto-Transfer: Learning to Route Transferrable Representations

## Requirements

- `python>=3.6`
- `pytorch>=1.1.0`
- `torchvision>=0.3.0`
- `cuda>=10.0`
- `pickle`
- `numpy`

**Note.** The reported results in our paper were obtained in `pytorch=1.1.0`, `torchvision=0.3.0`, `cuda=10.0`

## Prepare Datasets

You can download CUB-200, Stanford Dogs, MIT67 and Stanford40 datasets and place in the `data` folder:
- CUB-200: from http://www.vision.caltech.edu/visipedia/CUB-200-2011.html
- Stanford Dogs: http://vision.stanford.edu/aditya86/ImageNetDogs/
- MIT67: https://web.mit.edu/torralba/www/indoor.html
- Stanford40: http://vision.stanford.edu/Datasets/40actions.html

You need to run the below pre-processing script for DataLoader.

```bash
python cub200.py /data/CUB_200_2011
python dog.py /data/dog
python mit67.py /data/mit67
python stanford40.py /data/stanford40
```

## Train Auto-Transfer

You can train Auto-Transfer models with the same settings as in our manuscript using,

```bash
python train_auto_route.py --dataset cub200 --datasplit cub200 --dataroot /data/CUB_200_2011 --pairs auto --pretrained-src-model
python train_auto_route.py --dataset cub200 --datasplit cub200 --dataroot /data/CUB_200_2011 --pairs 1-1,2-2,3-3,4-4 --ru-units --pretrained-src-model
```
