# Brain2Music

Generating music from fMRI signals.

## Setup

(Unless shared directly,) clone the repository from GitHub and switch into the root directory

```shell
git clone https://github.com/f2mu/fmri2music fmri2music
cd fmri2music
mkdir -p data
```

Install requirements with

```shell
pip install -r requirements.txt
```

Create a `.env` file with the command

```shell
echo -e 'DATA_DIR=data\nPYTHONPATH=./fmri2music' > .env
```

Download all project-related data and place it in the `./data` folder. This includes

* `./data/MRI/fsROI/Subject0{1,2,3,4,5}/`
* `./data/music-emb/` with FMA and GTZAN embeddings (e.g., `fma-large.mv101.npz`)
* `./data/pred/` with model predictions, that is `.npz` files containing predictions of embeddings (e.g., MuLan) made by models based on fMRI data. A file name may be `gtzan-regression-mlp-mse-20230504-mv109-val-fmri.npz`.
* `./data/resp/Subject0{1,2,3,4,5}_RespData.mat` with response data from the five subjects. These files are around a GB each.
* `./data/stim/Exp{Trn,Val}Order.mat`

The fMRI data is available [here](https://openneuro.org/datasets/ds003720/versions/1.0.0) and the corresponding music (aka. stimuli) [here](https://www.kaggle.com/datasets/andradaolteanu/gtzan-dataset-music-genre-classification).
Music embeddings are not public and must be computed after a music embedding model has been chosen.
Our text caption dataset is available for download [anonymized; see ./caption-data.csv].

Run tests

```shell
pytest fmri2music
```

Next you may want to execute one of the scripts in `fmri2music/scripts`.
