"""Hyperparameter ranges for experiments reported in the paper."""
from fmri2music import hparam_tuner, data_const

# Configuration for testing only.
TEST_EXPERIMENT: hparam_tuner.HParamRanges = {
    "emb_name": ["window10s-stride1_5s-mv101-avg"],
    "nroi_used_for_ensemble": [6],
    "haemodynamic_resp_delay": [2],
    # "excluded_genre": data_const.GTZAN_GENRES,
    "voxel_num_limit": [5],
}

# This is to report the main results of the paper.
MAIN_EXPERIMENT: hparam_tuner.HParamRanges = {
    "emb_name": [
        # "window15s-stride15s-mv109-avg",
        # "window15s-stride15s-mv101txt-avg",
        # "window15s-stride15s-w2vbert-avg",
        # "window15s-stride15s-soundstream-avg",
        "window10s-stride1_5s-mv101-avg",
        # "window10s-stride1_5s-mv109-avg",
        "window5s-stride1_5s-w2vbert-avg",
        "window1_5s-stride1_5s-soundstream-avg",
    ],
    # Hparams below are tuned separately using only training data.
    "nroi_used_for_ensemble": [6],
    "haemodynamic_resp_delay": [2],
}

# Leave-one-genre-out study.
LEAVE_GENRE_OUT_EXPERIMENT: hparam_tuner.HParamRanges = {
    "emb_name": [
        # "window15s-stride15s-mv109-avg",
        # "window15s-stride15s-mv101txt-avg",
        # "window15s-stride15s-w2vbert-avg",
        # "window15s-stride15s-soundstream-avg",
        "window10s-stride1_5s-mv101-avg",
        # "window10s-stride1_5s-mv109-avg",
        "window5s-stride1_5s-w2vbert-avg",
        "window1_5s-stride1_5s-soundstream-avg",
    ],
    "nroi_used_for_ensemble": [6],
    "haemodynamic_resp_delay": [2],
    "excluded_genre": data_const.GTZAN_GENRES,
}
