"""Tests for quant_eval.py"""

import numpy as np

from fmri2music.quant_eval import cos_sim, identification


def test_cos_sim():
    vec1 = np.array([1, 0])
    vec2 = np.array([1, 1])
    vec3 = np.array([-1, -1])

    assert np.isclose(cos_sim(vec1, vec2), np.sqrt(2) / 2)
    assert cos_sim(vec1, vec2) > cos_sim(vec1, vec3)


def test_identification_with_identical_matrices():
    mat = np.random.rand(5, 5)

    # Test with same matrix, the identification accuracy should be 1 for all elements.
    result = identification(mat, mat)
    assert np.all(result == 1)
