from fmri2music.training_encoder import prepare_roi
from fmri2music import mapping, data_const
import numpy as np
import argparse
import os

import cortex
import numpy as np
from dotenv import find_dotenv, load_dotenv

from fmri2music import mapping
from fmri2music.training_encoder import prepare_roi

"""
Map with Mulan16d
python -m fmri2music.scripts.mapper \
    --model_name "mulan16d" \
    --subject_name "Subject01"

Map with Mulan128d
python -m fmri2music.scripts.mapper \
    --model_name "mulan128d" \
    --subject_name "Subject01"

Map with w2vbert
python -m fmri2music.scripts.mapper \
    --model_name "w2vbert" \
    --subject_name "Subject01"

Map with hum2search-v13
python -m fmri2music.scripts.mapper \
    --model_name "hum2search-v13" \
    --subject_name "Subject01"

Map with multiple
python -m fmri2music.scripts.mapper \
    --model_name "mulan128d_mulan16d_w2vbert_hum2search-v13" \
    --subject_name "Subject01"

Compare all models
python -m fmri2music.scripts.mapper \
    --model_name "mulan16d" "mulan128d" "w2vbert" "hum2search-v13" \
    --subject_name "Subject01"

"""


def main(args):
    mapping.mapper(
        args.subject_name,
        f"{args.subject_name}_xfm",
        args.model_name,
    )


if __name__ == "__main__":
    load_dotenv(find_dotenv())

    parser = argparse.ArgumentParser(
        description="Map prediction scores to brain surface."
    )

    parser.add_argument(
        "--model_name",
        nargs="*",
        type=str,
        required=True,
        help="Name of the model to be used for mapping.",
    )

    parser.add_argument(
        "--subject_name",
        choices=data_const.SUBJECTS,
        required=True,
        help="Name of subject for brain surface visualization.",
    )

    main(parser.parse_args())
