## Source code of PLMTrajRec: A Scalable and Generalizable Trajectory Recovery Framework with Pre-trained Language Model


## Dataset

We provide sample data under ./load_data/data/

BERT is downloaded at https://github.com/google-research/bert and stored in ./PLM

### Training PLMTrajRec on sparse trajectory with three sampling intervals:

```
python main.py --dataset Porto --repeat_time 3 --road_candi True --gpu_id 7 --soft_traj_num 512
```


### Fine-Tune PLMTrajRec on sparse trajectory with single sampling interval:

**Sparse trajectory with sampling intervals of 4 minutes**

```
python finetune_main.py --dataset Porto --repeat_time 1 --road_candi True --gpu_id 7 --soft_traj_num 512 --keep_ratio 0.0625
```

**Sparse trajectory with sampling intervals of 2 minutes**

```
python finetune_main.py --dataset Porto --repeat_time 1 --road_candi True --gpu_id 7 --soft_traj_num 512 --keep_ratio 0.125
```

**Sparse trajectory with sampling intervals of 1 minute**

```
python finetune_main.py --dataset Porto --repeat_time 1 --road_candi True --gpu_id 7 --soft_traj_num 512 --keep_ratio 0.25
```

