# Project Structure
```txt
├── README.md
├── .cache
│   └── datasets
|       ├── glue
|       |   ├── mnli
|       |   ├── mrpc
|       |   └── ...
|       ├── squad
|       └── squad_v2
├── script
└── src
    ├── bert
    └── t5
```

# Prepare Datasets

```python
python download_dataset.py
```

Due to network reasons, we pre-deposited the dataset on HuggingFace to disk via the save_to_disk function. You can replace load_from_disk in the code with load_dataset to use the dataset directly over the network.

glue: 

```
load_from_disk('../../.cache/datasets/{}/{}'.format(args.dataset, args.task_name))
```

to

```
load_dataset(args.dataset, args.task_name)
```

squad & squad_v2:

```
load_from_disk('../../.cache/datasets/{}'.format(data_args.dataset_name))
```

to

```
load_dataset(data_args.dataset_name)
```

# Train Baseline

```bash
bash script/train_bert.sh
bash script/train_t5.sh
```

# Compress Model

```bash
bash script/run_bert.sh
bash script/run_t5.sh
```
