#! /bin/bash

set -e

cd src/bert

device=2
redu_hidden_size=576
redu_attention_size=576
redu_intermediate_size=2304

# sst2 stsb mrpc mnli qqp qnli
for task_name in sst2 stsb mrpc mnli qqp qnli
do
 python glue_collect_compression_params.py \
   --dataset glue \
   --task_name ${task_name} \
   --redu_hidden_size ${redu_hidden_size} \
   --redu_attention_size ${redu_attention_size} \
   --device cuda:${device}
done

for task_name in sst2 stsb mrpc mnli qqp qnli
do
  python glue_run_compression.py \
    --dataset glue \
    --task_name ${task_name} \
    --redu_hidden_size ${redu_hidden_size} \
    --redu_attention_size ${redu_attention_size} \
    --redu_intermediate_size ${redu_intermediate_size} \
    --device cuda:${device}
done

# squad squad_v2
for dataset_name in squad squad_v2
do
CUDA_VISIBLE_DEVICES=${device} python squad_collect_compression_params.py \
    --output_dir=log/${dataset_name}_collect_params \
    --dataset_name=${dataset_name} \
    --max_seq_length 384 \
    --doc_stride 128 \
    --do_eval \
    --per_device_eval_batch_size=1 \
    --redu_hidden_size ${redu_hidden_size} \
    --redu_attention_size ${redu_attention_size} \

CUDA_VISIBLE_DEVICES=${device} python squad_run_compression.py \
    --output_dir=log/${dataset_name} \
    --dataset_name=${dataset_name} \
    --num_train_epochs 2 \
    --max_seq_length 384 \
    --doc_stride 128 \
    --do_train \
    --do_eval \
    --save_strategy=no \
    --per_device_train_batch_size=16 \
    --per_device_eval_batch_size=16 \
    --redu_hidden_size ${redu_hidden_size} \
    --redu_attention_size ${redu_attention_size} \
    --redu_intermediate_size ${redu_intermediate_size}
done
