#! /bin/bash

set -e

device=0
r_model=576
r_kv=48
r_ff=2304
de_num_layers=12
#r_model=384
#r_kv=36
#r_ff=1536
#de_num_layers=12

echo r_model=${r_model}
echo r_kv=${r_kv}
echo r_ff=${r_ff}
echo de_num_layers=${de_num_layers}

cd src/t5

exit

for task_name in mnli qqp qnli sst2 stsb mrpc
do
 python glue_collect_compression_params.py \
   --dataset glue \
   --task_name ${task_name} \
   --r_model ${r_model} \
   --r_kv ${r_kv} \
   --comp_mode 1 \
   --device cuda:${device}
done

for task_name in sst2 stsb mrpc qnli mnli qqp
do
 python glue_run_compression.py \
   --dataset glue \
   --task_name ${task_name} \
   --r_model ${r_model} \
   --r_kv ${r_kv} \
   --r_ff ${r_ff} \
   --de_num_layers ${de_num_layers} \
   --comp_mode 1 \
   --device cuda:${device}
done

for dataset_name in squad squad_v2
do
  CUDA_VISIBLE_DEVICES=${device} python squad_collect_compression_params.py \
      --output_dir=log/${dataset_name}_collect_params \
      --dataset_name=${dataset_name} \
      --max_seq_length 384 \
      --doc_stride 128 \
      --do_eval \
      --per_device_eval_batch_size=1 \
      --r_model ${r_model} \
      --r_kv ${r_kv} \
      --comp_mode=1
done

# squad squad_v2
for dataset_name in squad squad_v2
do
  CUDA_VISIBLE_DEVICES=${device} python squad_run_compression.py \
      --output_dir=log/${dataset_name} \
      --dataset_name=${dataset_name} \
      --predict_with_generate \
      --num_train_epochs 2 \
      --max_seq_length 384 \
      --doc_stride 128 \
      --do_train \
      --do_eval \
      --save_strategy=no \
      --per_device_train_batch_size=16 \
      --per_device_eval_batch_size=16 \
      --r_model ${r_model} \
      --r_kv ${r_kv} \
      --r_ff ${r_ff} \
      --de_num_layers ${de_num_layers} \
      --comp_mode=1
done
