#! /bin/bash

set -e

cd src/bert

# sst2 stsb mrpc mnli qqp qnli
device=0

for task_name in sst2 stsb mrpc mnli qqp qnli
do
 python glue_train_teacher.py \
   --dataset glue --task_name ${task_name} --device cuda:${device}
done

CUDA_VISIBLE_DEVICES=${device} python squad_train_teacher.py \
 --dataset_name squad \
 --output_dir log/squad \
 --do_train \
 --do_eval \
 --per_device_train_batch_size=16 \
 --learning_rate 3e-5 \
 --num_train_epochs 2 \
 --max_seq_length 384 \
 --doc_stride 128 \
 --save_strategy=no
 --evaluation_strategy=epoch

CUDA_VISIBLE_DEVICES=${device} python squad_train_teacher.py \
  --dataset_name squad_v2 \
  --output_dir log/squad_v2 \
  --do_train \
  --do_eval \
  --per_device_train_batch_size=16 \
  --learning_rate 3e-5 \
  --num_train_epochs 2 \
  --max_seq_length 384 \
  --doc_stride 128 \
  --save_strategy=no \
  --evaluation_strategy=epoch
