#! /bin/bash

set -e

device=0
model_name=t5-small
nlu_batch_size=16
nlg_batch_size=16
# t5-base, t5-large

cd src/t5

for task_name in sst2 stsb mrpc mnli qqp qnli
do
  python glue_train_teacher.py \
    --dataset glue \
    --task_name ${task_name} \
    --model_name ${model_name} \
    --batch_size ${nlu_batch_size} \
    --device cuda:${device}
done

CUDA_VISIBLE_DEVICES=${device} python squad_train_teacher.py \
  --model_name_or_path ${model_name} \
  --dataset_name squad \
  --output_dir log/squad \
  --do_train \
  --do_eval \
  --per_device_train_batch_size=${nlg_batch_size} \
  --learning_rate 3e-5 \
  --num_train_epochs 2 \
  --max_seq_length 384 \
  --doc_stride 128 \
  --save_strategy=no \
  --evaluation_strategy=epoch

CUDA_VISIBLE_DEVICES=${device} python squad_train_teacher.py \
  --model_name_or_path ${model_name} \
  --dataset_name squad_v2 \
  --output_dir log/squad_v2 \
  --do_train \
  --do_eval \
  --per_device_train_batch_size=${nlg_batch_size} \
  --learning_rate 3e-5 \
  --num_train_epochs 2 \
  --max_seq_length 384 \
  --doc_stride 128 \
  --save_strategy=no \
  --evaluation_strategy=epoch
