rm(list=ls())
setwd('PATH_TO_DATA')
filename = 'PATH_TO_DATA'
options(warn = -1)
library(reshape)
library(ggplot2)

#############################################################################################
## Compare the results on the generated interventionals with the ground-truth interventionals
#############################################################################################

df_tradeoff = as.data.frame(matrix(nrow=0, ncol = 4))
dfBase_tradeoff = as.data.frame(matrix(nrow=0, ncol = 4))

rawRMSE <- read.csv(paste0(filename,"/RMSE.csv", sep=""))
rawUnfairness <- read.csv(paste0(filename,  "/Unfairness.csv", sep=""))
rawRMSEIF <- read.csv(paste0(filename, "/RMSEIF.csv", sep=""))
rawUnfairnessIF <- read.csv(paste0(filename, "/UnfairnessIF.csv", sep=""))

# rawRMSEIF_truth <- read.csv(paste0(filename, "/RMSEIF_truth.csv", sep=""))
# rawUnfairnessIF_truth <- read.csv(paste0(filename, "/UnfairnessIF_truth.csv", sep=""))
RMSE <- na.omit(rawRMSE); Unfairness <- na.omit(rawUnfairness)
RMSEIF <- na.omit(rawRMSEIF); UnfairnessIF <- na.omit(rawUnfairnessIF)
# RMSEIF_truth <- na.omit(rawRMSEIF_truth); UnfairnessIF_truth <- na.omit(rawUnfairnessIF_truth)

cutoff_gene = intersect(which(RMSEIF$X10IF<5), which(UnfairnessIF$X0.0IF<5))
# cutoff_truth = intersect(which(RMSEIF_truth$X10IF<5), which(UnfairnessIF_truth$X0.0IF<5))
cutoff_gene = intersect(which(RMSEIF$X20IF<5), which(UnfairnessIF$X0.0IF<5))
# cutoff_truth = intersect(which(RMSEIF_truth$X20IF<5), which(UnfairnessIF_truth$X0.0IF<5))

# cutoff_gene = intersect(which(RMSEIF$X10IF<20), which(UnfairnessIF$X0.0IF<5))
# cutoff_gene = intersect(which(RMSEIF$X20IF<20), which(UnfairnessIF$X0.0IF<5))

# cutoff = intersect(cutoff_gene, cutoff_truth)
cutoff = cutoff_gene

RMSE = RMSE[cutoff,]; Unfairness = Unfairness[cutoff,]
RMSE_mean <- colMeans(RMSE); Unfairness_mean <- colMeans(Unfairness)

RMSEIF = RMSEIF[cutoff,]; UnfairnessIF = UnfairnessIF[cutoff,]
RMSEIF_mean <- colMeans(RMSEIF); UnfairnessIF_mean <- colMeans(UnfairnessIF)

# RMSEIF_truth = RMSEIF_truth[cutoff,]; UnfairnessIF_truth = UnfairnessIF_truth[cutoff,]
# RMSEIF_truth_mean <- colMeans(RMSEIF_truth); UnfairnessIF_truth_mean <- colMeans(UnfairnessIF_truth)

df = data.frame(Unfairness = UnfairnessIF_mean, RMSE = RMSEIF_mean, type = paste(d, "nodes", sep = ''), source = "Gene")
# dftruth = data.frame(Unfairness = UnfairnessIF_truth_mean, RMSE = RMSEIF_truth_mean, type = paste(d, "nodes", sep = ''), source = "Real")
dfBase = data.frame(Unfairness = Unfairness_mean[c(2,3)], RMSE = RMSE_mean[c(2,3)], type = paste(d, "nodes", sep = ''), source = "Real")
# df_tradeoff=rbind(df_tradeoff, df, dftruth)
df_tradeoff=rbind(df_tradeoff, df)
dfBase_tradeoff=rbind(dfBase_tradeoff, dfBase)


# pdf(paste0(filename,"/data/Tradeoff.pdf", sep=""), width = 14, height = 7)
ggplot(data = df_tradeoff, mapping = aes(x = RMSE, y = Unfairness, color = type, linetype = source)) + geom_line() + geom_point() +
  geom_point(data = dfBase_tradeoff, mapping = aes(x = RMSE, y = Unfairness, color = type, linetype = source)) +
  theme(legend.position = "top",
        legend.title = element_blank(),
        legend.text=element_text(size = 12),
        axis.title=element_text(size = 20))
# dev.off()

