# Video2EEG-SGGN-Diffusion 项目总览

## 项目简介

Video2EEG-SGGN-Diffusion 是一个基于MGIF框架的先进视频到脑电信号生成模型，整合了多项前沿技术：

- **Graph-DA 数据增强**: 基于图结构的数据增强方法
- **E-Graph与S-Graph构建**: 双图结构建模EEG通道关系
- **滤波器组驱动的多图建模**: 多频段图结构建模
- **自博弈融合策略**: 博弈论启发的信息融合
- **扩散模型**: 高质量EEG信号生成

## 技术架构

### 核心组件

```
Video2EEG-SGGN-Diffusion
├── 视频编码器 (Video Encoder)
│   ├── 3D CNN特征提取
│   └── 时序建模
├── 图神经网络模块 (Graph Neural Networks)
│   ├── E-Graph (空间先验图)
│   ├── S-Graph (信号相关性图)
│   └── 多尺度图卷积
├── 滤波器组处理器 (Filter Bank Processor)
│   ├── 多频段分解
│   └── 频段特定图构建
├── 自博弈融合模块 (Self-Game Fusion)
│   ├── 攻击-防御机制
│   └── 动态权重学习
└── 扩散生成器 (Diffusion Generator)
    ├── 噪声调度
    └── 去噪网络
```

### 数据流程

1. **输入处理**: 视频帧序列 → 特征提取
2. **图构建**: EEG通道 → E-Graph + S-Graph
3. **多频段建模**: 信号分解 → 频段特定图
4. **特征融合**: 自博弈策略 → 统一表示
5. **EEG生成**: 扩散过程 → 高质量EEG信号

## 项目结构

```
Video2EEG-SGGN-Diffusion/
├── README.md                           # 项目说明文档
├── PROJECT_OVERVIEW.md                 # 项目总览（本文件）
├── requirements.txt                     # 依赖包列表
├── config.json                         # 模型配置文件
│
├── 核心代码/
│   ├── video2eeg_sggn_diffusion_model.py  # 主模型定义
│   ├── train_sggn_diffusion.py            # 训练脚本
│   └── inference_sggn_diffusion.py        # 推理脚本
│
├── 示例代码/
│   ├── examples/
│   │   ├── train_example.py               # 训练示例
│   │   └── inference_example.py           # 推理示例
│
└── 文档/
    ├── TECHNICAL_DETAILS.md               # 技术细节文档
    └── API_REFERENCE.md                   # API参考文档
```

## 快速开始

### 1. 环境配置

```bash
# 克隆项目
cd /data0/GYF-projects/EEG2Video/Vidoe2EEG/Video2EEG-SGGN-Diffusion/

# 安装依赖
pip install -r requirements.txt
```

### 2. 数据准备

确保数据目录结构如下：
```
data/
├── subject_1/
│   ├── video_1_windows.npz
│   ├── video_2_windows.npz
│   └── ...
├── subject_2/
│   └── ...
└── ...
```

### 3. 模型训练

```bash
# 基础训练
python train_sggn_diffusion.py

# 自定义配置训练
python examples/train_example.py
```

### 4. 模型推理

```bash
# 基础推理
python inference_sggn_diffusion.py

# 推理示例
python examples/inference_example.py
```

## 核心技术详解

### Graph-DA 数据增强

- **原理**: 基于图结构的数据增强，通过建模传感器和脑电通道间的拓扑结构
- **实现**: `GraphDataAugmentation` 类
- **效果**: 缓解因信号退化造成的分布偏差

### E-Graph与S-Graph构建

#### E-Graph (空间先验图)
- **基础**: 传感器电极的球面距离
- **特点**: 编码空间先验知识
- **应用**: 空间特征建模

#### S-Graph (信号相关性图)
- **基础**: 脑电信号间的相关性（余弦距离）
- **特点**: 反映信号统计特性
- **应用**: 动态关系建模

### 滤波器组驱动的多图建模

- **频段分解**: Delta, Theta, Alpha, Beta, Gamma
- **多图构建**: 每个频段独立构建S-Graph
- **信息整合**: 综合各频段信息

### 自博弈融合策略

- **博弈模型**: "攻击者" vs "防御者"
- **学习目标**: 在电极缺失情况下保持性能
- **实现**: `SelfGameFusion` 模块

## 模型配置

### 关键参数

```json
{
  "model": {
    "eeg_channels": 64,
    "signal_length": 1000,
    "video_feature_dim": 512,
    "diffusion_steps": 1000,
    "frequency_bands": {
      "delta": [0.5, 4],
      "theta": [4, 8],
      "alpha": [8, 13],
      "beta": [13, 30],
      "gamma": [30, 100]
    }
  },
  "training": {
    "epochs": 100,
    "batch_size": 16,
    "learning_rate": 1e-4
  }
}
```

### 数据增强配置

```json
{
  "dataset": {
    "use_graph_da": true,
    "augmentation_ratio": 0.3,
    "augmentation_strategies": [
      "channel_dropout",
      "temporal_shift",
      "amplitude_scaling",
      "frequency_masking"
    ]
  }
}
```

## 性能指标

### 评估维度

1. **时域特征**
   - 均值相似性
   - 标准差相似性
   - 偏度、峰度匹配

2. **频域特征**
   - 功率谱密度相似性
   - 频段能量分布
   - 相干性分析

3. **空间特征**
   - 通道间相关性
   - 全局场功率
   - 拓扑分布

4. **统计特征**
   - 信噪比
   - 熵值分析
   - 分布匹配度

### 质量评分

- **优秀**: 综合评分 ≥ 0.8
- **良好**: 综合评分 ≥ 0.6
- **一般**: 综合评分 ≥ 0.4
- **需改进**: 综合评分 < 0.4

## 使用场景

### 研究应用

1. **脑机接口研究**
   - EEG信号模拟
   - 数据增强
   - 算法验证

2. **神经科学研究**
   - 视觉-神经关联分析
   - 认知机制研究
   - 神经解码

3. **临床应用**
   - 神经疾病诊断
   - 康复训练
   - 认知评估

### 工程应用

1. **数据生成**
   - 训练数据扩充
   - 稀有事件模拟
   - 隐私保护数据生成

2. **系统测试**
   - 算法鲁棒性测试
   - 极端条件模拟
   - 性能基准测试

## 扩展开发

### 模型扩展

1. **新的图构建方法**
   - 功能连接图
   - 因果关系图
   - 多模态图

2. **增强的融合策略**
   - 注意力机制
   - 元学习方法
   - 强化学习

3. **改进的扩散模型**
   - 条件扩散
   - 潜在扩散
   - 快速采样

### 应用扩展

1. **多模态输入**
   - 音频-EEG
   - 文本-EEG
   - 传感器-EEG

2. **实时处理**
   - 在线推理
   - 流式处理
   - 边缘计算

## 故障排除

### 常见问题

1. **内存不足**
   - 减少batch_size
   - 使用梯度累积
   - 启用混合精度训练

2. **训练不收敛**
   - 调整学习率
   - 检查数据质量
   - 修改网络架构

3. **推理速度慢**
   - 减少扩散步数
   - 使用模型量化
   - 优化计算图

### 调试技巧

1. **可视化分析**
   - 损失曲线
   - 梯度分布
   - 特征图可视化

2. **性能分析**
   - 内存使用监控
   - 计算时间分析
   - GPU利用率检查

## 贡献指南

### 代码贡献

1. **代码规范**
   - 遵循PEP 8
   - 添加类型注解
   - 编写文档字符串

2. **测试要求**
   - 单元测试覆盖
   - 集成测试
   - 性能测试

3. **提交流程**
   - Fork项目
   - 创建特性分支
   - 提交Pull Request

### 文档贡献

1. **技术文档**
   - API文档
   - 教程编写
   - 示例代码

2. **用户文档**
   - 使用指南
   - 最佳实践
   - 常见问题解答

## 版本历史

### v1.0.0 (当前版本)

- ✅ 基础SGGN-Diffusion模型实现
- ✅ Graph-DA数据增强
- ✅ E-Graph与S-Graph构建
- ✅ 滤波器组多图建模
- ✅ 自博弈融合策略
- ✅ 完整训练和推理流程
- ✅ 多维度质量评估
- ✅ 可视化分析工具

### 未来版本规划

#### v1.1.0
- 🔄 性能优化
- 🔄 更多数据增强策略
- 🔄 改进的可视化工具

#### v1.2.0
- 🔄 多模态输入支持
- 🔄 实时推理优化
- 🔄 模型压缩技术

#### v2.0.0
- 🔄 全新架构设计
- 🔄 端到端优化
- 🔄 生产环境部署

## 许可证

本项目采用 MIT 许可证，详见 LICENSE 文件。

## 联系方式

- **项目维护者**: 算法工程师
- **技术支持**: 通过GitHub Issues
- **学术合作**: 欢迎学术交流与合作

## 致谢

感谢以下项目和研究工作的启发：

- MGIF框架的原始实现
- PyTorch和PyTorch Geometric社区
- 脑机接口研究社区的贡献
- 扩散模型研究的进展

---

**注**: 本项目仅用于研究目的，使用时请遵循相关的伦理规范和法律法规。