# SEED-VD数据集生成方案

基于Video2EEG-SGGN-Diffusion模型的SEED-VD数据集生成完整解决方案。

## 概述

本方案提供了一个完整的数据集生成流程，能够：

1. **处理SEED-VD原始数据**：将原始的视频和EEG数据处理成模型可用的格式
2. **生成对应的EEG数据**：使用训练好的Video2EEG-SGGN-Diffusion模型为不同视频生成对应的EEG数据
3. **构建完整数据集**：创建包含训练/验证/测试分割的完整数据集
4. **质量评估和可视化**：提供生成质量评估和结果可视化

## 文件结构

```
Video2EEG-SGGN-Diffusion/
├── seed_vd_dataset_generator.py    # 核心数据集生成器
├── run_seed_vd_generation.py       # 简化运行脚本
├── seed_vd_config.yaml             # 配置文件
├── SEED_VD_DATASET_README.md       # 本文档
└── improved_inference_sggn.py       # 改进的推理脚本
```

## 数据要求

### 输入数据结构

1. **视频数据** (`/data0/GYF-projects/EEG2Video/dataset/Video/`)：
   ```
   Video/
   ├── 1st_10min.mp4
   ├── 2nd_10min.mp4
   ├── ...
   ├── 7th_10min.mp4
   ├── BLIP-caption/
   └── meta-info/
   ```

2. **EEG数据** (`/data0/GYF-projects/EEG2Video/data/Rawf_200Hz/`)：
   ```
   Rawf_200Hz/
   ├── sub1.npy
   ├── sub2.npy
   ├── ...
   └── sub20.npy
   ```

### 数据格式说明

- **视频**：1920x1080分辨率，24fps，每个视频10分钟
- **EEG**：形状为(7, 62, 104000)，表示7个块、62个通道、104000个时间点
- **采样率**：EEG数据200Hz，经过(0.1-99)Hz带通滤波

## 安装和依赖

### 环境要求

- Python 3.8+
- PyTorch 1.9+
- CUDA 11.0+ (推荐)

### 安装依赖

```bash
pip install torch torchvision torchaudio
pip install numpy pandas matplotlib seaborn
pip install opencv-python scipy tqdm
pip install pyyaml pathlib
```

## 使用方法

### 1. 快速开始

最简单的使用方式是运行快速测试：

```bash
python run_seed_vd_generation.py --quick_test
```

这将使用少量数据进行完整流程测试。

### 2. 配置文件方式

1. **编辑配置文件** `seed_vd_config.yaml`：
   ```yaml
   data_paths:
     video_dir: "/path/to/your/video/data"
     eeg_dir: "/path/to/your/eeg/data"
     model_path: "/path/to/your/trained/model.pth"
   ```

2. **运行完整流程**：
   ```bash
   python run_seed_vd_generation.py --config seed_vd_config.yaml
   ```

### 3. 分步执行

#### 步骤1：仅处理原始数据
```bash
python run_seed_vd_generation.py --mode process
```

#### 步骤2：仅生成EEG数据集
```bash
python run_seed_vd_generation.py --mode generate
```

### 4. 命令行参数

```bash
python run_seed_vd_generation.py \
    --mode both \
    --video_dir /path/to/video \
    --eeg_dir /path/to/eeg \
    --model_path /path/to/model.pth \
    --output_dir /path/to/output \
    --num_samples 100 \
    --device cuda
```

## 配置参数说明

### 数据处理参数

- `segment_duration`: 片段持续时间（秒），默认10.0
- `samples_per_video`: 每个视频的样本数，默认20
- `overlap_ratio`: 片段重叠比例，默认0.5
- `subject_ids`: 使用的被试ID列表，null表示自动检测
- `video_ids`: 使用的视频ID列表，默认[1,2,3,4,5,6,7]

### 生成参数

- `num_samples`: 生成样本数，null表示全部
- `batch_size`: 批处理大小，默认1
- `split`: 使用的数据集分割，默认"test"
- `dataset_name`: 生成数据集名称

### 视频处理参数

- `target_fps`: 目标帧率，默认8
- `target_size`: 目标尺寸，默认[224, 224]

## 输出结果

### 处理后的数据结构

```
seed_vd_processed_data/
├── train/
│   ├── subject_1_video_1_sample_0.npz
│   ├── subject_1_video_1_sample_1.npz
│   └── ...
├── val/
├── test/
├── dataset_split.json
└── dataset_stats.json
```

### 生成的数据集结构

```
seed_vd_generated_dataset/
└── seed_vd_generated/
    ├── generated_eeg_dataset.npz
    ├── quality_metrics.json
    ├── metadata.json
    ├── dataset_report.json
    └── visualizations/
        ├── quality_distributions.png
        ├── eeg_comparison_example_1.png
        ├── eeg_comparison_example_2.png
        └── eeg_comparison_example_3.png
```

### 数据文件说明

1. **generated_eeg_dataset.npz**：
   - `generated_eegs`: 生成的EEG数据
   - `reference_eegs`: 参考EEG数据
   - `video_data`: 对应的视频数据
   - `inference_times`: 推理时间

2. **quality_metrics.json**：质量评估指标
   - MSE (均方误差)
   - MAE (平均绝对误差)
   - 相关性系数
   - 频域特征对比

3. **dataset_report.json**：数据集统计报告
   - 样本数量统计
   - 质量指标统计
   - 性能统计

## 质量评估

生成的数据集包含多种质量评估指标：

### 时域指标
- **MSE (均方误差)**：衡量生成信号与真实信号的整体差异
- **MAE (平均绝对误差)**：衡量平均偏差
- **相关性系数**：衡量信号间的线性相关性

### 频域指标
- **功率谱密度对比**：比较不同频带的功率分布
- **频谱相关性**：频域信号的相关性

### 统计特性
- **均值和方差对比**：统计特性的一致性
- **分布相似性**：信号分布的相似程度

## 可视化功能

系统自动生成多种可视化图表：

1. **质量指标分布图**：MSE、MAE、相关性的分布直方图
2. **EEG信号对比图**：生成信号与真实信号的时域对比
3. **推理时间分布**：模型推理性能统计

## 性能优化建议

### 硬件要求
- **GPU内存**：建议8GB以上
- **系统内存**：建议32GB以上
- **存储空间**：建议100GB以上可用空间

### 优化策略
1. **批处理大小**：根据GPU内存调整batch_size
2. **并行处理**：利用多核CPU进行数据预处理
3. **混合精度**：使用FP16减少内存占用
4. **数据缓存**：预处理数据缓存到SSD

## 故障排除

### 常见问题

1. **内存不足**：
   - 减少batch_size
   - 减少samples_per_video
   - 使用更短的segment_duration

2. **模型加载失败**：
   - 检查模型文件路径
   - 确认模型文件完整性
   - 检查CUDA版本兼容性

3. **数据路径错误**：
   - 确认视频和EEG数据路径正确
   - 检查文件权限
   - 验证数据文件格式

4. **推理速度慢**：
   - 使用GPU加速
   - 减少扩散步数
   - 启用混合精度训练

### 调试模式

启用详细日志：
```bash
python run_seed_vd_generation.py --log_level DEBUG
```

## 扩展功能

### 自定义数据增强

可以在`SEEDVDDataProcessor`类中添加自定义的数据增强方法：

```python
def custom_augmentation(self, eeg_data, video_data):
    # 添加自定义增强逻辑
    return augmented_eeg, augmented_video
```

### 自定义质量评估

可以在`EEGQualityEvaluator`类中添加新的评估指标：

```python
def custom_metric(self, generated, reference):
    # 计算自定义指标
    return metric_value
```

## 实验记录

系统自动记录实验信息：
- 配置参数
- 数据统计
- 质量指标
- 运行时间
- 错误日志

所有实验记录保存在输出目录中，便于后续分析和复现。

## 引用和致谢

如果使用本方案，请引用相关论文：

```bibtex
@article{video2eeg_sggn,
  title={Video2EEG: Cross-Modal EEG Generation using SGGN Diffusion},
  author={Your Name},
  journal={Your Journal},
  year={2025}
}
```

## 联系方式

如有问题或建议，请联系：
- 邮箱：your.email@example.com
- 项目地址：https://github.com/your-repo/video2eeg-sggn

## 更新日志

### v1.0.0 (2025-01-12)
- 初始版本发布
- 支持SEED-VD数据集处理
- 集成Video2EEG-SGGN-Diffusion模型
- 提供完整的质量评估和可视化

---

**注意**：本方案仅用于学术研究目的，请遵守相关数据使用协议和伦理规范。