# Video2EEG-SGGN-Diffusion 训练数据流程详解

## 概述

本文档详细解释了 `train_sggn_diffusion.py` 脚本的完整数据流程，该脚本实现了基于SGGN（Spatial-Graph Graph Neural Network）和扩散模型的Video2EEG转换系统。

## 数据流程图

![数据流程图](train_sggn_diffusion_data_flow.png)

## 详细流程说明

### 1. 数据输入层 (Data Input Layer)

#### 1.1 原始数据文件
- **文件格式**: `subject_*_video_*.npz`
- **数据内容**: 
  - EEG数据: 脑电信号，通常为62通道
  - Video数据: 视频帧序列，RGB格式
  - 元数据: subject_id, video_id等

#### 1.2 数据集分割
- **分割文件**: `dataset_split.json`
- **分割类型**: 
  - `train`: 训练集
  - `val`: 验证集
  - `test`: 测试集

### 2. 数据加载层 (Data Loading Layer)

#### 2.1 SGGNEEGVideoDataset类
- **功能**: 自定义数据集类，继承自PyTorch Dataset
- **特性**:
  - 支持多种数据格式（新旧格式兼容）
  - 预加载数据信息以提高效率
  - 支持Graph-DA数据增强

### 3. 数据预处理层 (Data Preprocessing Layer)

#### 3.1 EEG数据处理
```python
# 数据形状标准化
eeg_data.shape = (62, 200)  # 62通道，200时间点

# 长度标准化
if eeg_data.shape[1] != target_length:
    # 截断或填充到目标长度
    
# 数据类型转换
eeg_data = eeg_data.astype(np.float32)
```

#### 3.2 视频数据处理
```python
# 标准化到[0,1]范围
if video_data.max() > 1.0:
    video_data = video_data / 255.0

# 维度调整: (T, H, W, C) -> (T, C, H, W)
video_data = np.transpose(video_data, (0, 3, 1, 2))

# 下采样: 224x224 -> 32x32 (减少计算量)
# 使用平均池化
```

#### 3.3 Graph-DA数据增强
仅在训练集上应用，包含四种策略：

1. **高斯噪声添加**
   ```python
   noise_level = np.random.uniform(0, 15)  # dB
   noise = np.random.normal(0, sqrt(noise_power), shape)
   ```

2. **通道随机丢弃**
   ```python
   dropout_ratio = np.random.uniform(0.05, 0.15)
   # 随机选择通道置零
   ```

3. **时间偏移**
   ```python
   shift_samples = np.random.randint(-10, 11)
   # 循环移位操作
   ```

4. **幅度缩放**
   ```python
   scale_factor = np.random.uniform(0.8, 1.2)
   # 整体幅度调整
   ```

### 4. 数据加载器层 (DataLoader Layer)

#### 4.1 DataLoader配置
- **批次大小**: 可配置（默认4）
- **多进程**: 支持多worker并行加载
- **分布式采样**: 支持多GPU训练
- **内存固定**: 启用pin_memory加速GPU传输

### 5. 模型层 (Model Layer)

#### 5.1 Video2EEG-SGGN-Diffusion模型
核心组件包括：

1. **E-Graph构建**: 基于电极空间位置的图结构
2. **S-Graph构建**: 基于信号相似性的图结构
3. **滤波器组**: 多频带信号分解
4. **扩散过程**: 噪声添加和去噪
5. **自博弈融合**: 多图信息融合策略

#### 5.2 模型输入输出
```python
# 输入
video_frames: (B, T, C, H, W)  # 视频帧序列
eeg_data: (B, 62, 200)         # EEG信号
timesteps: (B,)                # 扩散时间步

# 输出
predicted_noise: (B, 62, 200)  # 预测噪声
target_noise: (B, 62, 200)     # 目标噪声
adversarial_loss: scalar       # 对抗损失
```

### 6. 训练过程 (Training Process)

#### 6.1 前向传播
- **混合精度训练**: 使用torch.cuda.amp.autocast()
- **随机时间步**: 每个batch随机生成扩散时间步
- **多GPU支持**: 使用DistributedDataParallel

#### 6.2 损失计算
```python
# 主要损失: MSE损失
mse_loss = F.mse_loss(predicted_noise, target_noise)

# 对抗损失
adversarial_loss = model.compute_adversarial_loss()

# 总损失
total_loss = mse_loss + lambda_adv * adversarial_loss
```

#### 6.3 反向传播
- **梯度缩放**: 混合精度训练中的梯度缩放
- **梯度裁剪**: 防止梯度爆炸
- **参数更新**: 优化器步进

### 7. 输出层 (Output Layer)

#### 7.1 模型检查点
- **保存内容**: 模型权重、优化器状态、训练配置
- **保存策略**: 每epoch保存，最佳模型单独保存
- **文件格式**: `.pth`文件

#### 7.2 TensorBoard日志
- **训练损失**: 实时记录各种损失值
- **学习率**: 记录学习率变化
- **梯度信息**: 记录梯度范数
- **模型参数**: 记录参数分布

#### 7.3 训练报告
- **性能指标**: 损失值、准确率等
- **训练时间**: 每epoch耗时统计
- **资源使用**: GPU内存、计算利用率

#### 7.4 可视化图表
- **训练曲线**: 损失和指标随时间变化
- **学习率曲线**: 学习率调度可视化
- **数据分布**: EEG信号分布分析

## 关键技术特点

### 1. 多模态数据处理
- **EEG信号**: 时序脑电数据，62通道×200时间点
- **视频数据**: RGB视频帧，降采样到32×32减少计算量
- **同步对齐**: 确保EEG和视频数据时间同步

### 2. Graph-DA数据增强
- **图结构感知**: 考虑EEG通道间的空间关系
- **多策略组合**: 噪声、丢弃、偏移、缩放四种策略
- **自适应强度**: 根据数据特性调整增强强度

### 3. SGGN图神经网络
- **双图结构**: E-Graph（空间）+ S-Graph（信号）
- **多尺度建模**: 滤波器组驱动的多频带分析
- **自博弈融合**: 动态权重分配的信息融合

### 4. 扩散模型架构
- **噪声调度**: 可学习的噪声添加策略
- **条件生成**: 以视频为条件生成EEG
- **质量控制**: 多层次质量评估机制

### 5. 分布式训练支持
- **多GPU并行**: 支持单机多卡和多机多卡
- **混合精度**: 加速训练并减少内存使用
- **动态负载均衡**: 自适应batch分配

## 性能优化策略

### 1. 内存优化
- **视频下采样**: 32×32分辨率减少内存占用
- **梯度检查点**: 减少前向传播内存
- **数据预加载**: 异步数据加载

### 2. 计算优化
- **混合精度**: FP16计算加速
- **算子融合**: 减少kernel启动开销
- **批处理**: 最大化GPU利用率

### 3. I/O优化
- **数据缓存**: 预加载热点数据
- **并行加载**: 多进程数据读取
- **内存固定**: 加速CPU-GPU传输

## 总结

该数据流程实现了从原始多模态数据到训练完成模型的完整pipeline，具有以下优势：

1. **完整性**: 覆盖数据预处理到模型输出的全流程
2. **可扩展性**: 支持分布式训练和大规模数据
3. **鲁棒性**: 多种数据增强和质量控制机制
4. **高效性**: 多层次性能优化策略
5. **可监控性**: 完善的日志和可视化系统

这个设计为Video2EEG任务提供了一个强大而灵活的训练框架。