import numpy as np
import torch

def get_elmes(p: int, C: int) -> torch.Tensor:
    """
    Construct ELMES (equal length, maximally equi-separated) label embeddings.

    Args:
        p: Embedding dimension.
        C: Number of classes.

    Returns:
        (C, p) tensor of label embeddings on CUDA device.
    """
    ones = torch.ones((C, 1), dtype=torch.float32)
    M_star = torch.sqrt(torch.tensor(C / (C - 1))) * (
        torch.eye(C) - 1 / C * torch.matmul(ones, ones.t()))
    np.random.seed(50)
    U = np.random.random(size=(p, C))
    U = torch.tensor(np.linalg.qr(U)[0][:, :C]).to(torch.float32)
    return (U @ M_star).T.cuda()
