def get_model_dimensions(model_name: str) -> tuple:
    """
    Get feature dimensions for different model architectures.

    Args:
        model_name: Name of the model architecture.

    Returns:
        (feature_dim, transformer_dim)
    """
    model_dims = {
        'swin_tiny_patch4_window7_224': (768, 768),
        'swin_small_patch4_window7_224': (768, 768),
        'swin_base_patch4_window7_224': (1024, 1024),
        'swin_large_patch4_window7_224': (1536, 1536),
        'clip': (512, 512),  # CLIP ViT-B/32 dimensions
        'resnet18': (512, 512),
        'resnet34': (512, 512),
        'resnet50': (2048, 2048),
        'resnet101': (2048, 2048),
        'resnet152': (2048, 2048),
        'mobilevit_s': (640, 640),
        'vit_base_patch16_224': (768, 768),
        'eva02_base_patch14_224.mim_in22k': (768, 768),
        'coatnet_3_rw_224.sw_in12k': (768, 768),
        'convnextv2_large.fcmae_ft_in22k_in1k_384': (1536, 1536),
        'convnextv2_tiny.fcmae_ft_in22k_in1k_384': (768, 768),
        'maxvit_small_tf_512.in1k': (768, 768),
    }
    return model_dims.get(model_name, (768, 768))
