def process_state(observations, ):
    '''
    Param:
        observations: list of observations from the environment
        ...
    Return:
        obs: tuples (food_info, agents_info):
        ...

    '''
    food_info = {}
    agents_info = {}
    obs = observations[0]
    for idx in range(f):
        ...
        # Some explanination ...
        ...
        # Some processing ...
        ...
    return food_info, agents_info


def planning_function(processed_state):
    """
    Determines optimal tasks for each agent based on the current state.
    
    Args:
        processed_state: A tuple containing food location and level, agent position and level.

    Returns:
        dict: Optimal tasks for each agent ('No op','Target food 0','Target food 1','Pickup')
    """
    food_info, agents_info = processed_state
    llm_tasks = {}
    
    # Calculate total agent level
    total_agent_level = sum(agent[1] for agent in agents_info.values())
    
    # Find the highest level food that can be picked up
    target_food = None
    for food_id, food_data in food_info.items():
        if food_data is not None and food_data[1] <= total_agent_level:
            if target_food is None or food_data[1] > food_info[target_food][1]:
                target_food = food_id
    
    if target_food is None:
        # If no food can be picked up, assign 'No op' to all agents
        return {agent: 'No op' for agent in agents_info}
    
    target_food_pos = food_info[target_food][0]
    
    for agent_id, (agent_pos, _) in agents_info.items():
        if np.linalg.norm(np.array(agent_pos) - np.array(target_food_pos)) <= 1:
            llm_tasks[agent_id] = 'Pickup'
        else:
            llm_tasks[agent_id] = f'Target food {target_food[-1]}'
    
    return llm_tasks