import numpy as np
from onpolicy.prompts.util import process_actions
def process_global_state(global_state, n=3, m=3):
    '''
    Param:
        observation:
                        Dict of list of (n, ): dict('agent_0', 'agent_1', ..., 'agent_N')
                        List:
                        Agent : (m, ) list of observation components
        n: int, number of agents
        m: int, number of enemies
    Return:
        obs (tuples of dict): Tuples of dict of (n, ): Tuple of each observation components processed from each agent's perspective by function "process_observation":
            available_move_actions (dict of list): Dict of list of (4, ): dict('agent_0', 'agent_1', ..., 'agent_N') List of available moves for each agent. This might be empty if the agent is dead or no available move direction.
                    ->available_move_actions[agent_id]: the available list looks like list of string ["North", "South", "East", and "West"] directions
            enemy_info (dict of dict of tuple): Dict of dict of tuple of (n, ): dict('agent_0', 'agent_1', ..., 'agent_N') Tuple of m enemies information(enemy_0 to enemy_m) for each agent.
                    ->enemy_info[agent_id][enemy_id]: each tuple contains information of (is current enemy available to attack, distant to current enemy, x direction position to current enemy, y direction position to current enemy, is current enemy visible, enemy health, enemy's x pos to center, enemy's y pos to center)
            ally_info (dict of dict of tuple): Dict of dict of tuple of (n, ): dict('agent_0', 'agent_1', ..., 'agent_N') Tuple of n-1 ally information(exclude self) for each agent.
                    ->ally_info[agent_id][al_id]: each tuple contains information of (is current ally visible, distant to current ally, x direction position to current ally, y direction position to current ally, ally's attack cooldown condition, ally's health, ally's x pos to center, ally's y pos to center)
            own_info (dict of tuple): Dict of tuple of (n, ): dict('agent_0', 'agent_1', ..., 'agent_N') Tuple of own information for each agent.  
                    ->own_info[agent_id]: each tuple contains information of (your health, your x position to center, your y position to center, last action you take, whether you are alived)
    '''
    available_move_actions = {}
    enemy_info = {}
    ally_info = {}
    own_info = {}
    action_num = 6+m
    for id, obs in enumerate(global_state):
        agent_id = f"agent_{id}"
        offset = 0
        al_ids = [f"agent_{al_id}" for al_id in range(n) if f"agent_{al_id}" != agent_id]
        ally_info[agent_id] = {}
        for al_id in al_ids:
            ally_info[agent_id][al_id] = []
            # whether the ally is visible or in the sight range of the agent
            is_current_ally_visible = obs[offset: offset + 1]
            ally_info[agent_id][al_id].append(is_current_ally_visible)
            offset += 1
            # distance to the ally
            dist_to_ally = obs[offset: offset + 1]
            ally_info[agent_id][al_id].append(dist_to_ally)
            offset += 1
            # ally's position relative to the agent
            pos_x_to_ally = obs[offset: offset + 1]
            ally_info[agent_id][al_id].append(pos_x_to_ally)
            pos_y_to_ally = obs[offset + 1: offset + 2]
            ally_info[agent_id][al_id].append(pos_y_to_ally)
            offset += 2
            # the time left for the ally to use the weapon
            weapon_cooldown = obs[offset: offset + 1]
            ally_info[agent_id][al_id].append(weapon_cooldown)
            offset += 1
            # health of the ally(0 to 1)
            ally_health = obs[offset: offset + 1]
            ally_info[agent_id][al_id].append(ally_health)
            offset += 1
            # ally's position relative to the center of the map
            pos_x_to_center = obs[offset: offset + 1]
            ally_info[agent_id][al_id].append(pos_x_to_center)
            offset += 1
            pos_y_to_center = obs[offset: offset + 1]
            ally_info[agent_id][al_id].append(pos_y_to_center)
            offset += 1
            # the last action of the ally(str)
            last_action = process_actions(obs[offset: offset + action_num])
            ally_info[agent_id][al_id].append(last_action)
            offset += action_num
            # whether the ally is alived
            ally_alived = True
            if last_action == "no operation":
                ally_alived = False
            ally_info[agent_id][al_id].append(ally_alived)
            ally_info[agent_id][al_id] = tuple(ally_info[agent_id][al_id])
        e_ids = [f"enemy_{e_id}" for e_id in range(m)]
        enemy_info[agent_id] = {}
        for e_id in e_ids:
            # whether the enemy is available to attack
            is_current_enemy_available_to_attack = obs[offset: offset + 1]
            offset += 1
            # distance to the enemy
            dist_to_enemy = obs[offset: offset + 1]
            offset += 1
            # enemy's position relative to the agent
            pos_x_to_enemy = obs[offset: offset + 1]
            pos_y_to_enemy = obs[offset + 1: offset + 2]
            offset += 2
            # whether the enemy is visible or in the sight range of the agent
            is_current_enemy_visible = obs[offset: offset + 1]
            offset += 1
            # health of the enemy(0 to 1)
            enemy_health = obs[offset: offset + 1]
            offset += 1
            # enemy's position relative to the center of the map
            enemy_pos_x_to_center = obs[offset: offset + 1]
            offset += 1
            enemy_pos_y_to_center = obs[offset: offset + 1]
            offset += 1
            enemy_info[agent_id][e_id] = (
                is_current_enemy_available_to_attack, dist_to_enemy, pos_x_to_enemy, pos_y_to_enemy,
                is_current_enemy_visible, enemy_health, enemy_pos_x_to_center, enemy_pos_y_to_center)

        move_feat = obs[: 4]
        available_moves= []
        if move_feat[0] == 1:
            available_moves.append("North")
        if move_feat[1] == 1:
            available_moves.append("South")
        if move_feat[2] == 1:
            available_moves.append("East")
        if move_feat[3] == 1:
            available_moves.append("West")
        available_move_actions[agent_id] = available_moves
        offset += 4

        offset += 4
        own_info[agent_id] = []
        own_health = obs[offset: offset + 1]
        own_info[agent_id].append(own_health)
        offset += 1
        own_pos_x_to_center = obs[offset: offset + 1]
        own_info[agent_id].append(own_pos_x_to_center)
        offset += 1
        own_pos_y_to_center = obs[offset: offset + 1]
        own_info[agent_id].append(own_pos_y_to_center)
        offset += 1
        own_last_action = process_actions(obs[offset: offset + action_num])
        own_info[agent_id].append(own_last_action)
        offset += action_num
        own_alived = True
        if own_last_action == "no operation":
            own_alived = False
        own_info[agent_id].append(own_alived)
        own_info[agent_id] = tuple(own_info[agent_id])

        processed_global_state = (available_move_actions, enemy_info, ally_info, own_info)

    return processed_global_state