import os
from os.path import join
import torch
from enum import Enum
from parse import parse_args
import multiprocessing

os.environ['KMP_DUPLICATE_LIB_OK'] = 'True'
args = parse_args()

ROOT_PATH = os.path.dirname(os.path.dirname(__file__))
CODE_PATH = join(ROOT_PATH, 'code')
DATA_PATH = join(ROOT_PATH, 'data')
BOARD_PATH = join(CODE_PATH, 'runs')
if len(args.board_path) > 0:
	BOARD_PATH = join(BOARD_PATH, args.board_path)
FILE_PATH = join(CODE_PATH, 'checkpoints', args.test_set)
import sys
sys.path.append(join(CODE_PATH, 'sources'))


if not os.path.exists(FILE_PATH):
    os.makedirs(FILE_PATH, exist_ok=True)


config = {}

config['base_model'] = args.base_model
config['test_set'] = args.test_set
config['batch_size'] = args.batch_size
config['latent_dim_rec'] = args.recdim
config['dropout'] = args.dropout
config['test_u_batch_size'] = args.testbatch
config['multicore'] = args.multicore
config['lr'] = args.lr
config["alpha"] = args.alpha
config["K"] = args.K
config['pretrain'] = args.pretrain
config['A_split'] = False
config['bigdata'] = False
config["loss_func"] = args.loss_func
config["lambda"] = args.lam
config["n_negative"] = args.n_negative

GPU = torch.cuda.is_available()
device = torch.device('cuda' if GPU else "cpu")
CORES = multiprocessing.cpu_count() // 2
seed = args.seed

dataset = args.dataset


TRAIN_epochs = args.epochs
LOAD = args.load
PATH = args.path
topks = eval(args.topks)
tensorboard = args.tensorboard
comment = args.comment
# let pandas shut up
from warnings import simplefilter
simplefilter(action="ignore", category=FutureWarning)

def cprint(words : str):
    print(f"\033[0;30;43m{words}\033[0m")
