## Steps

### Prepare dataset
```bash
python -m code.data prepare --dataset {mnist,celebahq64,cifar10}
python -m pytest code/data.py -k test_{mnist,celebahq64,cifar10}
```

### Train base model
```bash
horovodrun -n 2 python -O train_realnvp_horovod_v2.py {mnist,celebahq64_5bit,cifar10_5bit} \
    --root_dir checkpoints/realnvp_v2_{mnist,celebahq64_5bit,cifar10_5bit} --num_workers 16
```

### Image inpainting
DATA is one of `mnist`, `celebahq64`, or `cifar10`.
Replace the following hyperparameters with the values from the paper:
DATA, FORWARDOP (top_half, bottom_half, mar), N, SIGMA, BATCHSIZE, LEARNINGRATE

Ours:
```bash
python run_vi.py --data DATA \
    --root_dir results/inpainting/DATA_vi \
    --base_ckpt path/to/checkpoint.pt --base_model DATA --cond_model vi_default \
    --forward_op FORWARDOP --num_steps N --sigma SIGMA --batch_size BATCH_SIZE \
    --learning_rate LEARNINGRATE --index_range 0 10 --sample_steps N

```

Ambient VI:
```bash
python run_ambient.py --data DATA \
    --root_dir results/inpainting/DATA_vi \
    --base_ckpt path/to/checkpoint.pt --base_model DATA --vi_model naive_default \
    --forward_op FORWARDOP --num_steps N --sigma SIGMA --batch_size BATCH_SIZE \
    --learning_rate LEARNINGRATE --index_range 0 10
```

Langevin Dynamics:
```bash
python run_sgld.py --data DATA \
    --root_dir results/inpainting/DATA_langevin  \
    --base_ckpt path/to/checkpoint.pt --base_model DATA
    --forward_op FORWARDOP --num_steps N --sigma SIGMA --batch_size BATCH_SIZE \
    --learning_rate LEARNINGRATE --index-range 0 10 --num_samples 8 --num_steps N --sample_steps N
```

PL-MCMC:
```bash
python run_plmcmc.py --data mnist \
    --root_dir results/inpainting/mnist \
    --base_ckpt path/to/checkpoint.pt --base_model mnist
    --forward_op FORWARDOP --sigma_a 1e-3 --sigma_p 0.05 --batch_size BATCHSIZE \
    --num_samples 6 --burn_in 2000  --index_range 0 10
```

