# Deep Convolutional Generative Adversarial Network (DC-GAN)

A Generative Adversarial Network (GAN) comprises two neural networks: a **Generator** and a **Discriminator**, engaged in a minimax game. The generator fabricates synthetic images out of a noisy input, while the discriminator evaluates the authenticity of these samples, distinguishing between real data and the generated ones. Through iterative training, the generator learns to produce increasingly realistic outputs that deceive the discriminator, while the discriminator enhances its ability to differentiate genuine from fake data.

## Parameters

<center>

| Argument                      | Description                                        | Default  | Choices                          |
|-------------------------------|----------------------------------------------------|----------|----------------------------------|
| `--batch_size`                | Batch size                                         | `128`    |                                  |
| `--dataset`                   | Dataset name                                       | `mnist`  | `mnist`, `cifar10`,`tinyimagenet`|
| `--n_epochs`                  | Number of epochs                                   | `100`    |                                  |
| `--lrg`                       | Learning rate generator                            | `0.0002` |                                  |
| `--lrd`                       | Learning rate discriminator                        | `0.0002` |                                  |
| `--beta1`                     | Beta1                                              | `0.5`    |                                  |
| `--beta2`                     | Beta2                                              | `0.999`  |                                  |
| `--latent_dim`                | Latent dimension                                   | `100`    |                                  |
| `--img_size`                  | Image size                                         | `32`     |                                  |
| `--channels`                  | Channels                                           | `1`      |                                  |
| `--sample_and_save_freq`      | Sample interval                                    | `5`      |                                  |
| `--checkpoint`                | Checkpoint path                                    | `None`   |                                  |
| `--discriminator_checkpoint`  | Discriminator checkpoint path                      | `None`   |                                  |
| `--n_samples`                 | Number of samples                                  | `9`      |                                  |
| `--d`                         | Number of filters first layer                      | `64`     |                                  |
| `--ood_task`                  | Type of OOD detection task                         | `near`   | `near`, `far`, `covar`           |

</center>

You can find out more about the parameters by checking [`util.py`](./../src/disconet/utils/util.py) or by running the following command on the example script:

    python train_dcgan.py --help

## Training

To replicate the experiments performed in the paper, please use the following commands:

**MNIST**

    python train_dcgan.py --dataset mnist --d 64 --latent_dim 512 --batch_size 512 --n_epochs 200 --lrd 1e-4 --lrg 1e-4

**CIFAR-10**

    python train_dcgan.py --dataset cifar10 --d 64 --latent_dim 1024 --batch_size 512 --n_epochs 200 --lrd 2e-4 --lrg 2e-4

**TinyImageNet**

    python train_dcgan.py --dataset tinyimagenet --d 64 --latent_dim 1024 --batch_size 512 --n_epochs 200 --lrd 2e-4 --lrg 2e-4

## OOD Detection

To perform OOD detection you must indicate your ID dataset, the type of OOD detection task you want to perform and provide the discriminator checkpoint:

    python eval_dcgan.py --ood_task near --dataset cifar10 --d 64 --latent_dim 1024 --discriminator_checkpoint ./../../models/DCGAN/GANDisc_cifar10.pt