---
language: 
- en
pretty_name: "Reformatted TriviaQA"
license: "apache-2.0"
source_datasets:
- mandarjoshi/trivia_qa
# disagree slightly with the official TriviaQA repo on *_creators fields
# the questions were written by trivia enthusiasts
# then the linking to evidence was machine driven, however the wikipedia page evidences are crowsourced
language_creators:
  - expert-generated
  - crowdsourced
annotations_creators:
  - crowdsourced
  - machine-generated
task_categories:
- text-generation
- question-answering
task_ids:
  - open-domain-qa
  - open-domain-abstractive-qa
  - extractive-qa
  - abstractive-qa
  - closed-book-qa
  - open-book-qa
# from the autogenerated README.md from repo creation w/o a README.md present
dataset_info:
- config_name: trivia_qa_cbqa_ds
  features:
  - name: question_id
    dtype: string
  - name: answer
    dtype: string
  - name: document_id
    dtype: string
  - name: normalized_answer
    dtype: string
  - name: alias_answer
    dtype: string
  - name: normalized_alias_answer
    dtype: string
  - name: input
    dtype: string
  - name: target
    dtype: string
  - name: target_norm_ans
    dtype: string
  - name: target_alias_ans
    dtype: string
  - name: target_norm_alias_ans
    dtype: string
  splits:
  - name: validation
    num_bytes: 1078665
    num_examples: 4103
  download_size: 800248
  dataset_size: 1078665
- config_name: trivia_qa_document_webtext_ds
  features:
  - name: question_id
    dtype: string
  - name: document_id
    dtype: string
  - name: text
    dtype: string
  splits:
  - name: validation
    num_bytes: 110748510
    num_examples: 4103
  download_size: 60537941
  dataset_size: 110748510
- config_name: trivia_qa_obqa_ds
  features:
  - name: question_id
    dtype: string
  - name: answer
    dtype: string
  - name: document_id
    dtype: string
  - name: normalized_answer
    dtype: string
  - name: alias_answer
    dtype: string
  - name: normalized_alias_answer
    dtype: string
  - name: input
    dtype: string
  - name: input_w_document
    dtype: string
  - name: target
    dtype: string
  - name: target_norm_ans
    dtype: string
  - name: target_alias_ans
    dtype: string
  - name: target_norm_alias_ans
    dtype: string
  splits:
  - name: validation
    num_bytes: 112105118
    num_examples: 4103
  download_size: 66545189
  dataset_size: 112105118
- config_name: trivia_qa_val_w_answers
  features:
  - name: question
    dtype: string
  - name: question_id
    dtype: string
  - name: answer
    dtype: string
  - name: document_id
    dtype: string
  - name: wiki_document
    dtype: string
  - name: normalized_answer
    dtype: string
  - name: alias_answer
    dtype: string
  - name: normalized_alias_answer
    dtype: string
  splits:
  - name: validation
    num_bytes: 111344754
    num_examples: 4103
  download_size: 60996144
  dataset_size: 111344754
configs:
- config_name: trivia_qa_cbqa_ds
  data_files:
  - split: validation
    path: trivia_qa_cbqa_ds/validation-*
  default: true
- config_name: trivia_qa_document_webtext_ds
  data_files:
  - split: validation
    path: trivia_qa_document_webtext_ds/validation-*
- config_name: trivia_qa_obqa_ds
  data_files:
  - split: validation
    path: trivia_qa_obqa_ds/validation-*
- config_name: trivia_qa_val_w_answers
  data_files:
  - split: validation
    path: trivia_qa_val_w_answers/validation-*
---
# Reformatted TriviaQA for use alongside FictionalQA

- **Repository:** Omitted
- **Paper:** Omitted

### Dataset Description

This dataset is a simple derived view of the validation data from the original TriviaQA dataset hosted by the original creators at [hf.co/datasets/mandarjoshi/trivia_qa](XXXX). To create this view, we extract the wikipedia articles associated with each question, as well as a simplified answer list, and then we create a few versions of the resulting data for use as pretraining webtext, and question answering pairs for finetuning and evaluation. See the paper for a description of how this data was used in the experiments.

### Citation

The original TriviaQA paper:
```bibtext
@article{2017arXivtriviaqa,
       author = {{Joshi}, Mandar and {Choi}, Eunsol and {Weld},
                 Daniel and {Zettlemoyer}, Luke},
        title = "{triviaqa: A Large Scale Distantly Supervised Challenge Dataset for Reading Comprehension}",
      journal = {arXiv e-prints},
         year = 2017,
          eid = {arXiv:1705.03551},
        pages = {arXiv:1705.03551},
archivePrefix = {arXiv},
       eprint = {1705.03551},
}
```

Our work:
```bibtext
Omitted
```