# Instructions

The code here reproduces one of our representative experiments: Chains of
matrix products that compound magnitudes beyond floating-point limits.

Our full codebase, reproducing all experiments, will be provided in the
camera-ready version of our paper.


## Installing

1. Install a recent version of Python.

2. Install all dependencies, listed in the file `requirements.txt`.

3. Edit the Python script `goom_experiment_1.py`, and set the `DEVICE`
   variable to a device in your system (e.g., `DEVICE = 'cuda'`).


## Running

Run the Python script `goom_experiment_1.py` (for example, by executing
`python goom_experiment_1.py` from the command line). The script will
attempt to compute chains of up to 1M products of real matrices, each
with elements independently sampled from a normal distribution, over
torch.float32, torch.float64, and complex64-typed GOOMs (i.e., GOOMS with
torch.float32 real and imaginary components). For every matrix size, for
each data type, the code will attempt to compute the entire chain 30 times.

WARNING: Execution will take a LONG time, because all product chains finish
successfully when executed over GOOMs.