import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt

data = {
    'layer': [12, 12, 12, 12, 12, 16, 16, 16, 16, 16, 20, 20, 20, 20, 20],
    'coefficient': [0.0, 1.0, 2.0, 3.0, 5.0, 0.0, 1.0, 2.0, 3.0, 5.0, 0.0, 1.0, 2.0, 3.0, 5.0],
    # 'accuracy': [0.9003, 0.9057, 0.8923, 0.8721, 0.3342, 0.9003, 0.9003, 0.8960, 0.8874, 0.8691, 0.9003, 0.9036, 0.9040, 0.9019, 0.8956]
    'accuracy': [0.7918, 0.8336, 0.8225, 0.7986, 0.3038, 0.7918, 0.8328, 0.8200, 0.8217, 0.7978, 0.7918, 0.8345, 0.8294, 0.8251, 0.8268]


}
df = pd.DataFrame(data)

heatmap_data = df.pivot(index='coefficient', columns='layer', values='accuracy')

ax = sns.heatmap(heatmap_data, annot=True, fmt=".4f", cmap="YlOrBr", cbar=True)
ax.collections[0].colorbar.set_label("Accuracy")

plt.xlabel("Layer")
plt.ylabel("Coefficient")
plt.title("ARC-Challenge: Layer vs Coefficient")

plt.savefig("analysis/output/heatmap_arc_c.png", dpi=300, bbox_inches='tight')
plt.show()
