import matplotlib.pyplot as plt
import numpy as np

x_labels = ["100%", "70%", "40%", "10%", "0%"]
x = list(range(len(x_labels)))
mmlu = [75.85, 74.47, 69.24, 67.33, 67.58]
csqa = [72.89, 73.05, 72.73, 73.14, 73.14]

title_font = {'fontsize': 15, 'weight': 'bold'}
axis_font = {'fontsize': 13}
tick_fontsize = 11

# ===== MMLU =====
plt.figure(figsize=(8, 5))
plt.plot(x_labels, mmlu, marker='o', markersize=10, linewidth=3, color='#1f77b4', label="MMLU")

for i, value in enumerate(mmlu):
    if i < 3:
        plt.text(x[i] - 0.03, value - 0.7, f"{value:.2f}", ha='center', va='top', fontsize=11)
    else:
        plt.text(x[i], value + 0.35, f"{value:.2f}", ha='center', va='bottom', fontsize=11)

plt.xlabel("Percentage of Training Data(%)", **axis_font)
plt.ylabel("Accuracy (%)", **axis_font)
plt.title("MMLU-Med", **title_font)
plt.grid(True, linestyle='--', linewidth=0.6, alpha=0.6)
plt.xticks(fontsize=tick_fontsize)
plt.yticks(fontsize=tick_fontsize)
plt.legend(fontsize=11)
plt.subplots_adjust(top=0.88, bottom=0.15)
plt.savefig("analysis/output/mmlu_training_per.png", dpi=300)
plt.show()
plt.close()

# ===== CSQA =====
plt.figure(figsize=(8, 5))
plt.plot(x_labels, csqa, marker='s', markersize=10, linewidth=3, color='#ff7f0e', label="CSQA")

for i, value in enumerate(csqa):
    if i == 3:
        plt.text(x[i], value - 0.3, f"{value:.2f}", ha='center', va='top', fontsize=11)  
    elif i == 4:
        plt.text(x[i], value - 0.3, f"{value:.2f}", ha='center', va='top', fontsize=11)
    else:
        plt.text(x[i], value + 0.2, f"{value:.2f}", ha='center', va='bottom', fontsize=11)

plt.xlabel("Percentage of Training Data(%)", **axis_font)
plt.ylabel("Accuracy (%)", **axis_font)
plt.title("CSQA-Val", **title_font)
plt.grid(True, linestyle='--', linewidth=0.6, alpha=0.6)
plt.xticks(fontsize=tick_fontsize)
plt.yticks(np.arange(68, 77, 2), fontsize=tick_fontsize)
plt.legend(fontsize=11)
plt.subplots_adjust(top=0.88, bottom=0.15)
plt.savefig("analysis/output/csqa_training_per.png", dpi=300)
plt.show()
plt.close()
