import argparse
from utils import load_json, save_json, filter_correct_reflections

def main():
    parser = argparse.ArgumentParser(description="Filter reflection QA results by correct answers.")
    parser.add_argument("--input", type=str, required=True, help="Path to input JSON file.")
    parser.add_argument("--output", type=str, required=True, help="Path to save filtered JSON file.")
    args = parser.parse_args()

    # Load dataset
    dataset = load_json(args.input)

    # Filter correct reflections
    filtered_results = filter_correct_reflections(dataset)

    # Save filtered dataset
    save_json(filtered_results, args.output)

    print(f"Total filtered records: {len(filtered_results)}")
    print(f"Filtered data saved to {args.output}")


if __name__ == "__main__":
    main()