def build_prompt_med(question: str) -> str:
    return f"""<|begin_of_text|><|start_header_id|>system<|end_header_id|>
You are an expert in medicine. Answer multiple-choice questions clearly and accurately.
<|eot_id|>

<|start_header_id|>user<|end_header_id|>
Please answer the following question. Provide concise reasoning if needed.

At the end, format your final answer using:
[ANSWER] (choice letter) [/ANSWER]

[Example Problem]
An investigator is studying the modification of newly formed polypeptides in plated eukaryotic cells. After the polypeptides are released from the ribosome, a chemically-tagged protein attaches covalently to lysine residues on the polypeptide chain, forming a modified polypeptide. When a barrel-shaped complex is added to the cytoplasm, the modified polypeptide lyses, resulting in individual amino acids and the chemically-tagged proteins. Which of the following post-translational modifications has most likely occurred?
(A) Acylation  
(B) Glycosylation  
(C) Phosphorylation  
(D) Carboxylation  
(E) Ubiquitination

[Example Solution]
The key detail is that a chemically-tagged protein is attached to lysine residues, and a barrel-shaped complex degrades the polypeptide into amino acids. This describes ubiquitination, where ubiquitin is attached to lysine residues, targeting the protein for degradation by the proteasome (barrel-shaped complex).
[ANSWER] (E) [/ANSWER]

Now answer this question:
{question}
<|eot_id|>
<|start_header_id|>assistant<|end_header_id|>
"""

def build_reflection_prompt_med(question: str, response_initial: str) -> str:
    return f"""<|begin_of_text|><|start_header_id|>system<|end_header_id|>
You are an expert in medicine. Reflect on your previous answer and evaluate its accuracy.
<|eot_id|>

<|start_header_id|>user<|end_header_id|>
Please review your previous answer to the following question.

Check for any errors or missing information in your reasoning.

If your original answer was incorrect, revise it. If it's correct, briefly justify why.

Use concise, medically accurate reasoning.

At the end, clearly format your final answer as:
[ANSWER] (choice letter) [/ANSWER]

The parameter [choice] is the letter or number of the answer you want to select. (e.g. "A", "B", "C", or "D")

Question:
{question}

Previous answer:
{response_initial.split("assistant")[-1].strip()}

Now reflect:
<|eot_id|>

<|start_header_id|>assistant<|end_header_id|>
"""

def build_prompt_cs(question: str) -> str:
    return f"""<|begin_of_text|><|start_header_id|>system<|end_header_id|>
You are an expert in common sense reasoning. Answer multiple-choice questions clearly and accurately.
<|eot_id|>

<|start_header_id|>user<|end_header_id|>
Please answer the following question. Provide concise reasoning if needed.

At the end, format your final answer using:
[ANSWER] (choice letter) [/ANSWER]

[Example Problem]
Sammy wanted to go to where the people were.  Where might he go? 
(A) race track
(B) populated areas
(C) the desert
(D) apartment
(E) roadblock

[Example Solution]
The question asks where Sammy would go to find people. "The desert" and "roadblock" are unlikely to have many people. "Apartment" is specific and may or may not have many people. "Race track" has people during events but not always. "Populated areas" is the most general and consistently correct answer.
[ANSWER] (B) [/ANSWER]

Now answer this question:
{question}
<|eot_id|>
<|start_header_id|>assistant<|end_header_id|>
"""

def build_reflection_prompt_cs(question: str, response_initial: str) -> str:
    return f"""<|begin_of_text|><|start_header_id|>system<|end_header_id|>
You are an expert in common sense reasoning. Reflect on your previous answer and evaluate its accuracy.
<|eot_id|>

<|start_header_id|>user<|end_header_id|>
Please review your previous answer to the following question.

Check for any errors or missing information in your reasoning.

If your original answer was incorrect, revise it. If it's correct, briefly justify why.

Use concise, medically accurate reasoning.

At the end, clearly format your final answer as:
[ANSWER] (choice letter) [/ANSWER]

The parameter [choice] is the letter or number of the answer you want to select. (e.g. "A", "B", "C", or "D")

Question:
{question}

Previous answer:
{response_initial.split("assistant")[-1].strip()}

Now reflect:
<|eot_id|>

<|start_header_id|>assistant<|end_header_id|>
"""