function theta_update = ISTA(Sigma, delta, lambda, s)
    p = size(Sigma, 1);
    iter = 0;
    K = size(delta, 2);
    theta_old = zeros(p, K);
    theta_update = zeros(p, K);
    dif = 0;
    for t = 1:200
        grad = theta_old - s * (Sigma * theta_old - delta);
        for j = 1:p
            theta_update(j, :) = BST(grad(j, :), s*lambda);
            d = theta_update(j,:) - theta_old(j, :);
            dif = max(dif, max(abs(d)));
        end
        theta_old = theta_update;
        if dif < 1e-6
            break
        end
        if max(max(abs(theta_update), 1)) > 1e+3
            fprintf('bomb!')
            break
        end
    end
end