%MNIST
X = loadMNISTImages("train-images-idx3-ubyte");
Y = loadMNISTLabels("train-labels-idx1-ubyte");
test_X = loadMNISTImages("t10k-images-idx3-ubyte");
test_Y = loadMNISTLabels("t10k-labels-idx1-ubyte");
N = size(X, 1);
index = randperm(N, N);
X = X(index, :);
Y = Y(index);

Y = Y + 1;
test_Y = test_Y + 1;
K = 10;
p = 784;


train{1,1} = X;
train{1,2} = Y;
test{1,1} = test_X;
test{1,2} = test_Y;

data = data_with_Byzantine(train, test, 100, 0);
[error_1, error_2] = model_run(data, 5);

T = 20;
for i = 1:10
    index = randperm(N, N);
    X = X(index, :);
    Y = Y(index);
    train{1,1} = X;
    train{1,2} = Y;
    data = data_with_Byzantine(train, test, 20, 2);
    [error_iter(:, i), error_iter_1(:, i)] = model_run(data, T);
end
mean_error = mean(error_iter, 2);
median_error = mean(error_iter_1, 2);

for i = 1:10
    index = randperm(N, N);
    X = X(index, :);
    Y = Y(index);
    train{1,1} = X;
    train{1,2} = Y;
    data = data_with_Byzantine(train, test, 20, 0);
    [error_iter(:, i), error_iter_1(:, i)] = model_run(data, T);
end
