function data = data_with_Byzantine(train, test, M, Byzantine_num, K)
    train_X = train{1, 1};
    train_Y = train{1, 2};
    test_X = test{1, 1};
    test_Y = test{1, 2};
    N = size(train_X,1);
    data = cell(M+1,3);

    %first machine
    n = round(N/M);
    index = 1 : 1 : n;
    data{1,1} = train_X(index,:);
    data{1,2} = train_Y(index);
    data{1,3} = train_Y(index);
    %Byzantine machine
    for m = 2 : Byzantine_num + 1
        index = (m-1)* n +1 : 1 :m * n;
        data{m,1} = train_X(index,:);
        Y_true = train_Y(index);
        Y_replace = randi(K, n, 1);
        Y_replace = K+1 - Y_true;
        data{m,2} = Y_true;
        data{m,3} = Y_replace;
    end
    %Normal machine
    for m = Byzantine_num+2 : M-1
        index = (m-1) * n +1 : 1 :m * n;
        data{m,1} = train_X(index,:);
        data{m,2} = train_Y(index);
        data{m,3} = train_Y(index);
    end
    index = (M-1) * n +1 : N;
    data{M,1} = train_X(index,:);
    data{M,2} = train_Y(index);
    data{M,3} = train_Y(index);

    % test set
    data{M+1, 1} = test_X;
    data{M+1, 2} = test_Y;
end