%MNIST
X = loadMNISTImages("train-images-idx3-ubyte");
Y = loadMNISTLabels("train-labels-idx1-ubyte");
test_X = loadMNISTImages("t10k-images-idx3-ubyte");
test_Y = loadMNISTLabels("t10k-labels-idx1-ubyte");
N = size(X, 1);
index = randperm(N, N);
X = X(index, :);
Y = Y(index);

Y = Y + 1;
test_Y = test_Y + 1;
K = 10;
p = 784;


train{1,1} = X;
train{1,2} = Y;
test{1,1} = test_X;
test{1,2} = test_Y;

T = 10;
data_0 = data_with_Byzantine(train, test, 20, 0, K);
data_1 = data_with_Byzantine(train, test, 20, 2, K);
values = linspace(0.005, 0.1, 5);
[error_iter0, r_error_iter0] = model_run(data_0, T, K, values);
r_error_iter1 = median_run(data_1, T, K, values);
cen_error = msda_cen(train, test, K, values);


%% ISOLET
importdata('isolet.csv')
data = ans.data;
X = data(:, 1:617);
Y = data(:, 618);

importdata('isolet_test.csv')
test_data = ans.data;
test_X = test_data(:, 1:617);
test_Y = test_data(:, 618);

N = size(X, 1);
index = randperm(N, N);
X = X(index, :);
Y = Y(index);

values = linspace(0.01, 0.1, 5);
K = 26;

train{1,1} = X;
train{1,2} = Y;
test{1,1} = test_X;
test{1,2} = test_Y;
data = data_with_Byzantine(train, test, 10, 0, K);
[error_1, error_2] = model_run(data, 20, K, values);
data_1 = data_with_Byzantine(train, test, 10, 1, K);
error_3 = median_run(data_1, 20, K, values);
cen_error = msda_cen(train, test, K, values);
