function error_iter_1 = median_run(data, T, K, values)
    M = size(data, 1) - 1;
    test_X = data{M+1, 1};
    test_Y = data{M+1, 2};
    p = size(test_X, 2);

    
    % compute sigma_1
    train_X1 = data{1,1};
    train_Y1 = data{1,2};
    cov_class = zeros(p,p);
    X_class = cell(K,1);
    for k = 1:K
        ind_k = find(train_Y1 == k);
        X_class = train_X1(ind_k,:);
        mu_hat(:,k) = mean(X_class, 1)';
        pi_hat(k) = size(X_class,1);
        cov_class = cov_class + size(X_class,1) * cov(X_class);
    end
    Sigma_1 = cov_class/size(train_X1,1);
    pi_hat_1 = pi_hat/sum(pi_hat);
    delta_hat_1 = mu_hat - mu_hat(:,1);
    delta_hat_1(:,1) = [];

    %initial value
    theta_initial_1 = ISTA(Sigma_1, delta_hat_1, 0.5, 0.01);
    theta_choose = [zeros(p, 1) theta_initial_1];
    tpred_value = test_X * theta_choose + log(pi_hat_1);
    [max_a, index] = max(tpred_value');
    index = index';

    error_iter_1 = zeros(T+1,1);
    error_iter_1(1) = 1 - mean(index == test_Y);


    %% median of means
    %compute total mean and pi_k
    mu_store = cell(M,1);
    pi_store = zeros(M, K);
    for m = 1:M
        X = data{m,1};
        Y = data{m,3};
        for k = 1:K
            ind_k = find(Y == k);
            X_class = X(ind_k,:);
            mu_local(:,k) = mean(X_class,1)';
            pi_store(m,k) = size(X_class, 1);
        end
        mu_store{m} = mu_local;
        pi_store(m,:) = pi_store(m,:)/sum(pi_store(m,:));
    end
    mu_tilde = zeros(p,K);
    for k = 1:K
        mu_k = zeros(p, M);
        for m = 1:M
            mu_store_m = mu_store{m};
            mu_k(:,m) = mu_store_m(:,k);
        end
        mu_tilde(:,k) = median(mu_k, 2);
    end
    pi_tilde = median(pi_store, 1);
    delta_tilde = mu_tilde - mu_tilde(:,1);
    delta_tilde(:,1) = [];

    % iteration
    for t = 1:T
        t
        grad_store = cell(M,1);
        for m = 1:M
            X = data{m,1};
            Y = data{m,3};
            cov_class = zeros(p, p);
            for k = 1:K
                ind_k = find(Y == k);
                X_class = X(ind_k,:);
                cov_class = cov_class + size(X_class,1) * cov(X_class);
            end
            Sigma_local = cov_class/size(X,1);
            grad_store{m} = Sigma_local * theta_initial_1;
        end
        grad_tilde = zeros(p,K-1);
        for k = 1:K-1
            grad_k = zeros(p, M);
            for m = 1:M
                b_store_m = grad_store{m};
                grad_k(:,m) = b_store_m(:,k);
            end
            grad_tilde(:,k) = median(grad_k, 2);
        end
        delta = Sigma_1 * theta_initial_1 - grad_tilde + delta_tilde;
        
        lambda_1 = median_iter_CV(data, theta_initial_1, values, K);

        theta_update = ISTA(Sigma_1, delta, lambda_1, 0.01);
        theta_choose = [zeros(p, 1) theta_update];
        tpred_value = bayes_value(test_X, theta_choose, mu_tilde, pi_tilde, K);
        [max_a, index] = max(tpred_value');
        index = index';
        error_iter_1(t+1) = 1 - mean(index == test_Y);
        theta_initial_1 = theta_choose;
        theta_initial_1(:,1) = [];
    end
end