function pred_value = bayes_value(X, theta, mu_hat, pi_hat, K)
    n = size(X, 1);
    p = size(X, 2);
    pred_value = zeros(n, K);
    for i = 1:n
        for k = 1:K
            pred_value(i, k) = (X(i, :)' - (mu_hat(:, k) + mu_hat(:, 1))/2)'*theta(:, k) + log(pi_hat(k)/pi_hat(1));
        end
    end
    