function error_c = msda_cen(train_data, test_data, K, values)
    %data = data_1;
    train_X = train_data{1, 1};
    train_Y = train_data{1, 2};
    test_X = test_data{1, 1};  %last one : test dataset
    test_Y = test_data{1, 2};
    n = size(train_X, 1);
    p = size(train_X, 2);

    for i = 1:length(values)
        lambda = values(i);
        for j = 1:5
            rowindex = randperm(n, round(n/5));
            X_tmp = train_X(setdiff(1:n, rowindex), :);
            Y_tmp = train_Y(setdiff(1:n, rowindex));
            valid_X = train_X(rowindex, :);
            valid_Y = train_Y(rowindex);

            % compute Sigma, delta
            cov_class = zeros(p,p);
            mu_hat = zeros(p, K);

            for k = 1:K
                ind_k = find(Y_tmp == k);
                X_class = X_tmp(ind_k,:);
                cov_class = cov_class + size(X_class,1) * cov(X_class);
                mu_hat(:,k) = mean(X_class, 1)';
                pi_hat(k) = size(X_class,1);
            end
            Sigma = cov_class/size(X_tmp,1);
            pi_hat = pi_hat/sum(pi_hat);
            delta_hat = mu_hat - mu_hat(:,1);
            delta_hat(:,1) = [];

            % solve group lasso
            theta_tmp = ISTA(Sigma, delta_hat, lambda, 0.01);

            theta = [zeros(p, 1) theta_tmp];
            pred_value = bayes_value(valid_X, theta, mu_hat, pi_hat, K);
            [max_a, index] = max(pred_value');
            index = index';
            cv_accuracy(j) = mean(index == valid_Y);
        end
        lambda_accuracy(i) = mean(cv_accuracy);
    end

    lambda_choose = values(find(lambda_accuracy == max(lambda_accuracy))); % mean
    lambda_choose = lambda_choose(1);

    % compute Sigma, delta
    cov_class = zeros(p,p);
    mu_hat = zeros(p, K);

    for k = 1:K
        ind_k = find(train_Y == k);
        X_class = train_X(ind_k,:);
        cov_class = cov_class + size(X_class,1) * cov(X_class);
        mu_hat(:,k) = mean(X_class, 1)';
        pi_hat(k) = size(X_class,1);
    end
    Sigma = cov_class/n;
    pi_hat = pi_hat/sum(pi_hat);
    delta_hat = mu_hat - mu_hat(:,1);
    delta_hat(:,1) = [];

    % solve group lasso
    theta_cen = ISTA(Sigma, delta_hat, lambda_choose, 0.01);
    theta_choose = [zeros(p, 1) theta_cen];
    tpred_value = bayes_value(test_X, theta_choose, mu_hat, pi_hat, K);
    [max_a, index] = max(tpred_value');
    index = index';
    error_c = 1 - mean(index == test_Y);
end